/*
 * Decompiled with CFR 0.152.
 */
package org.zionusa.base.util.auth;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.zionusa.base.util.auth.AuthenticatedUser;

public class JWTAuthorizationFilter
extends BasicAuthenticationFilter {
    private final String environment;
    private String jwtSecret;

    public JWTAuthorizationFilter(AuthenticationManager authManager, String environment, String jwtSecret) {
        super(authManager);
        this.environment = environment;
        this.jwtSecret = jwtSecret;
    }

    protected void doFilterInternal(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        String header = req.getHeader("Authorization");
        if (header == null || !header.startsWith("Bearer ")) {
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
            return;
        }
        UsernamePasswordAuthenticationToken authentication = this.getAuthentication(req);
        SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        chain.doFilter((ServletRequest)req, (ServletResponse)res);
    }

    private UsernamePasswordAuthenticationToken getAuthentication(HttpServletRequest request) {
        String token = request.getHeader("Authorization");
        if (token != null && this.jwtSecret != null) {
            Claims claims = (Claims)Jwts.parser().setSigningKey(this.jwtSecret.getBytes()).parseClaimsJws(token.replace("Bearer ", "")).getBody();
            if (!this.environment.equals("test") && claims.getExpiration().before(new Date())) {
                return null;
            }
            String user = claims.getSubject();
            if (user != null && claims.get((Object)"authenticatedUser") != null) {
                String authorityString = (String)claims.get((Object)"authorities");
                authorityString = authorityString.substring(1, authorityString.length() - 1);
                AuthenticatedUser authenticatedUser = this.createAuthenticatedUser((LinkedHashMap)claims.get((Object)"authenticatedUser"), authorityString);
                if (authenticatedUser != null) {
                    return new UsernamePasswordAuthenticationToken((Object)authenticatedUser, null, (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{authorityString}));
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private AuthenticatedUser createAuthenticatedUser(LinkedHashMap<String, Object> authUserClaims, String authorityString) {
        List authorities = AuthorityUtils.createAuthorityList((String[])new String[]{authorityString});
        AuthenticatedUser authenticatedUser = new AuthenticatedUser((String)authUserClaims.get("username"), "", authorities);
        authenticatedUser.setId((Integer)authUserClaims.get("id"));
        if (authUserClaims.containsKey("parentChurchId")) {
            authenticatedUser.setParentChurchId((Integer)authUserClaims.get("parentChurchId"));
        }
        authenticatedUser.setUserApplicationRoles((List)authUserClaims.get("userApplicationRoles"));
        authenticatedUser.setChurchId((Integer)authUserClaims.get("churchId"));
        authenticatedUser.setGroupId((Integer)authUserClaims.get("groupId"));
        authenticatedUser.setTeamId((Integer)authUserClaims.get("teamId"));
        authenticatedUser.setDisplayName((String)authUserClaims.get("displayName"));
        authenticatedUser.setRole((String)authUserClaims.get("role"));
        authenticatedUser.setAccess((String)authUserClaims.get("access"));
        authenticatedUser.setTeamName((String)authUserClaims.get("teamName"));
        authenticatedUser.setGroupName((String)authUserClaims.get("groupName"));
        authenticatedUser.setChurchName((String)authUserClaims.get("churchName"));
        if (authenticatedUser.getUserApplicationRoles() == null) {
            authenticatedUser.setUserApplicationRoles(new ArrayList<String>());
        }
        return authenticatedUser;
    }
}

