/*
 * Decompiled with CFR 0.152.
 */
package org.zionusa.base.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static final Logger logger = LoggerFactory.getLogger(Util.class);

    public static Object runGetter(Field field, Object o) {
        for (Method method : Util.getMethods(o.getClass())) {
            if (!method.getName().startsWith("get") || method.getName().length() != field.getName().length() + 3 || !method.getName().toLowerCase().endsWith(field.getName().toLowerCase())) continue;
            try {
                return method.invoke(o, new Object[0]);
            }
            catch (IllegalAccessException e) {
                logger.error("Could not determine method: " + method.getName(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                logger.error("Could not determine method: " + method.getName(), (Throwable)e);
            }
        }
        return null;
    }

    public static Stack<Method> getMethods(Class type) {
        Stack<Method> result = new Stack<Method>();
        try {
            for (Class c = type; c != null; c = c.getSuperclass()) {
                Method[] methods = c.getDeclaredMethods();
                result.addAll(Arrays.asList(methods));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static Map<String, String> getFieldsAndValues(List<String> columns, Object classObject) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String column : columns) {
            try {
                Object value = Util.runGetter(classObject.getClass().getDeclaredField(column), classObject);
                result.put(column, value != null ? value.toString() : null);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

