package org.zionusa.base.util.auth;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
public class AuthenticatedUser extends User {

    public static String ADMIN_ACCESS = "Admin";
    public static String PASTOR_ROLE = "Pastor";
    public static String OVERSEER_ROLE = "Overseer";
    public static String CHURCH_LEADER_ROLE = "Church Leader";
    public static String GROUP_LEADER_ROLE = "Group Leader";
    public static String TEAM_LEADER_ROLE = "Team leader";
    public static String MEMBER_ROLE = "Member";

    private Integer id;
    private String displayName;
    private String role;
    private String access;
    private Integer teamId;
    private Integer groupId;
    private Integer churchId;
    private Integer parentChurchId;
    private String teamName;
    private String groupName;
    private String churchName;
    private String activeDirectoryId;
    private List<String> userApplicationRoles;
    private Date teamEffectiveDate;
    private Date groupEffectiveDate;
    private boolean theologicalStudent;

    public AuthenticatedUser() {
        super("", "", new ArrayList<>());
    }

    public AuthenticatedUser(String username, String password, Collection<? extends GrantedAuthority> authorities) {
        super(username, password, authorities);
    }

    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    public Date getTeamEffectiveDate(){return teamEffectiveDate;}

    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    public Date getGroupEffectiveDate(){return groupEffectiveDate;}

}
