/*
 * Decompiled with CFR 0.152.
 */
package org.zionusa.base.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javassist.NotFoundException;
import org.slf4j.Logger;
import org.springframework.data.jpa.repository.JpaRepository;
import org.zionusa.base.util.Util;

public class BaseService<T> {
    private JpaRepository<T, Integer> dao;
    private Logger logger;

    public BaseService(JpaRepository<T, Integer> dao, Logger logger) {
        this.dao = dao;
        this.logger = logger;
    }

    public List<T> getAll() {
        return this.dao.findAll();
    }

    public List<Map<String, String>> getAllDisplay(List<String> columns) {
        ArrayList<Map<String, String>> displayItems = new ArrayList<Map<String, String>>();
        this.dao.findAll().forEach(item -> {
            Map<String, String> displayContact = Util.getFieldsAndValues(columns, item);
            if (displayContact.size() > 0) {
                displayItems.add(displayContact);
            }
        });
        return displayItems;
    }

    public T getById(Integer id) throws NotFoundException {
        Optional optional = this.dao.findById((Object)id);
        if (!optional.isPresent()) {
            throw new NotFoundException(this.getClass().getName() + " could not be find the entity in the system");
        }
        Object entity = optional.get();
        this.logger.info("Retrieving entity: {}", entity);
        return entity;
    }

    public T save(T t) {
        this.logger.info("Attempting to save new entity: {}", t);
        return (T)this.dao.save(t);
    }

    public T update(T t) {
        this.logger.info("Attempting to update existing entity: {}", t);
        return (T)this.dao.save(t);
    }

    public void delete(Integer id) throws NotFoundException {
        Optional optional = this.dao.findById((Object)id);
        if (!optional.isPresent()) {
            throw new NotFoundException(this.getClass().getName() + "Cannot delete an entity that does not exist");
        }
        Object t = optional.get();
        this.logger.info("Attempting to delete entity: {}", t);
        this.dao.delete(t);
    }
}

