/*
 * Decompiled with CFR 0.152.
 */
package org.zionusa.base.controller;

import java.util.List;
import java.util.Map;
import javassist.NotFoundException;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.zionusa.base.service.BaseService;

public class BaseController<T> {
    private BaseService<T> service;

    public BaseController(BaseService<T> service) {
        this.service = service;
    }

    @RequestMapping(method={RequestMethod.GET})
    public List<T> getAll() {
        return this.service.getAll();
    }

    @PostMapping(value={"/display"})
    public List<Map<String, String>> getAllDisplay(@RequestBody List<String> columns) {
        return this.service.getAllDisplay(columns);
    }

    @GetMapping(value={"/{id}"})
    T getById(@PathVariable Integer id) throws NotFoundException {
        return this.service.getById(id);
    }

    @PostMapping
    T save(@Valid @RequestBody T t) {
        return this.service.save(t);
    }

    @PutMapping(value={"/{id}"})
    T update(@PathVariable Integer id, @Valid @RequestBody T t) {
        return this.service.save(t);
    }

    @DeleteMapping(value={"/{id}"})
    void delete(@PathVariable Integer id) throws NotFoundException {
        this.service.delete(id);
    }
}

