package org.zionusa.base.service;

import javassist.NotFoundException;
import org.slf4j.Logger;
import org.springframework.data.jpa.repository.JpaRepository;
import org.zionusa.base.util.Util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class BaseService<T> {

    private JpaRepository<T, Integer> dao;
    private Logger logger;

    public BaseService(JpaRepository<T, Integer> dao, Logger logger) {
        this.dao = dao;
        this.logger = logger;
    }

    public List<T> getAll() {
        return dao.findAll();
    }

    public List<Map<String, String>> getAllDisplay(List<String> columns) {
        List<Map<String, String>> displayItems = new ArrayList<>();

        dao.findAll().forEach(item -> {
            Map<String, String> displayContact = Util.getFieldsAndValues(columns, item);
            if (displayContact.size() > 0) displayItems.add(displayContact);
        });

        return displayItems;
    }

    public T getById(Integer id) throws NotFoundException {
        Optional<T> optional = dao.findById(id);

        if (!optional.isPresent())
            throw new NotFoundException(getClass().getName() + " could not be find the entity in the system");

        T entity = optional.get();

        logger.info("Retrieving entity: {}", entity);
        return entity;
    }

    public T save(T t) {

        logger.info("Attempting to save new entity: {}", t);
        return dao.save(t);
    }

    public T update(T t) {
        logger.info("Attempting to update existing entity: {}", t);
        return dao.save(t);
    }

    public void delete(Integer id) throws NotFoundException {
        Optional<T> optional = dao.findById(id);

        if (!optional.isPresent())
            throw new NotFoundException(getClass().getName() + "Cannot delete an entity that does not exist");

        T t = optional.get();

        logger.info("Attempting to delete entity: {}", t);

        dao.delete(t);
    }
}
