package org.zionusa.base.controller;

import javassist.NotFoundException;
import org.springframework.web.bind.annotation.*;
import org.zionusa.base.service.BaseService;

import javax.validation.Valid;
import java.util.List;
import java.util.Map;

public class BaseController<T> {

    private BaseService<T> service;

    public BaseController(BaseService<T> service) {
        this.service = service;
    }

    @RequestMapping(method = RequestMethod.GET)
    public List<T> getAll() {
        return service.getAll();
    }

    @PostMapping(value = "/display")
    public List<Map<String, String>> getAllDisplay(@RequestBody List<String> columns) {
        return service.getAllDisplay(columns);
    }

    @GetMapping(value = "/{id}")
    T getById(@PathVariable Integer id) throws NotFoundException {
        return service.getById(id);
    }

    @PostMapping()
    T save(@Valid @RequestBody T t){
        return service.save(t);
    }

    @PutMapping(value = "/{id}")
    T update(@PathVariable Integer id, @Valid @RequestBody T t) {
        return service.save(t);
    }

    @DeleteMapping(value = "/{id}")
    void delete(@PathVariable Integer id) throws NotFoundException {
        service.delete(id);
    }
}
