/*
 * Decompiled with CFR 0.152.
 */
package org.yuanheng.cookjson.value;

import java.util.HashMap;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;

public class CookJsonObject
extends HashMap<String, JsonValue>
implements JsonObject {
    private static final long serialVersionUID = -4911944799507752602L;

    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.OBJECT;
    }

    public JsonArray getJsonArray(String name) {
        return (JsonArray)this.get(name);
    }

    public JsonObject getJsonObject(String name) {
        return (JsonObject)this.get(name);
    }

    public JsonNumber getJsonNumber(String name) {
        return (JsonNumber)this.get(name);
    }

    public JsonString getJsonString(String name) {
        return (JsonString)this.get(name);
    }

    public String getString(String name) {
        return this.getJsonString(name).getString();
    }

    public String getString(String name, String defaultValue) {
        try {
            return this.getString(name);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public int getInt(String name) {
        return this.getJsonNumber(name).intValue();
    }

    public int getInt(String name, int defaultValue) {
        try {
            return this.getJsonNumber(name).intValue();
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String name) {
        JsonValue v = (JsonValue)this.get(name);
        if (v.getValueType() == JsonValue.ValueType.TRUE) {
            return true;
        }
        if (v.getValueType() == JsonValue.ValueType.FALSE) {
            return false;
        }
        throw new ClassCastException();
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        try {
            return this.getBoolean(name);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public boolean isNull(String name) {
        return ((JsonValue)this.get(name)).getValueType() == JsonValue.ValueType.NULL;
    }
}

