/*
 * Decompiled with CFR 0.152.
 */
package org.yuanheng.cookjson.value;

import java.util.ArrayList;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;

public class CookJsonArray
extends ArrayList<JsonValue>
implements JsonArray {
    private static final long serialVersionUID = 6159626473888359143L;

    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.ARRAY;
    }

    public JsonObject getJsonObject(int index) {
        return (JsonObject)this.get(index);
    }

    public JsonArray getJsonArray(int index) {
        return (JsonArray)this.get(index);
    }

    public JsonNumber getJsonNumber(int index) {
        return (JsonNumber)this.get(index);
    }

    public JsonString getJsonString(int index) {
        return (JsonString)this.get(index);
    }

    public <T extends JsonValue> List<T> getValuesAs(Class<T> clazz) {
        return this;
    }

    public String getString(int index) {
        return ((JsonString)this.get(index)).getString();
    }

    public String getString(int index, String defaultValue) {
        try {
            return this.getString(index);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public int getInt(int index) {
        return ((JsonNumber)this.get(index)).intValue();
    }

    public int getInt(int index, int defaultValue) {
        try {
            return this.getInt(index);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public boolean getBoolean(int index) {
        JsonValue v = (JsonValue)this.get(index);
        if (v.getValueType() == JsonValue.ValueType.TRUE) {
            return true;
        }
        if (v.getValueType() == JsonValue.ValueType.FALSE) {
            return false;
        }
        throw new ClassCastException();
    }

    public boolean getBoolean(int index, boolean defaultValue) {
        try {
            return this.getBoolean(index);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public boolean isNull(int index) {
        return ((JsonValue)this.get(index)).getValueType() == JsonValue.ValueType.NULL;
    }
}

