/*
 * Decompiled with CFR 0.152.
 */
package org.yuanheng.cookjson;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonParser;
import org.yuanheng.cookjson.BOM;
import org.yuanheng.cookjson.CookJsonGenerator;
import org.yuanheng.cookjson.CookJsonParser;
import org.yuanheng.cookjson.value.CookJsonArray;
import org.yuanheng.cookjson.value.CookJsonObject;

public class Utils {
    static void setInt(byte[] bytes, int value) {
        bytes[0] = (byte)(value & 0xFF);
        bytes[1] = (byte)(value >> 8 & 0xFF);
        bytes[2] = (byte)(value >> 16 & 0xFF);
        bytes[3] = (byte)(value >> 24 & 0xFF);
    }

    static void setLong(byte[] bytes, long value) {
        bytes[0] = (byte)(value & 0xFFL);
        bytes[1] = (byte)(value >> 8 & 0xFFL);
        bytes[2] = (byte)(value >> 16 & 0xFFL);
        bytes[3] = (byte)(value >> 24 & 0xFFL);
        bytes[4] = (byte)(value >> 32 & 0xFFL);
        bytes[5] = (byte)(value >> 40 & 0xFFL);
        bytes[6] = (byte)(value >> 48 & 0xFFL);
        bytes[7] = (byte)(value >> 56 & 0xFFL);
    }

    private static void addStructure(CookJsonParser p, JsonStructure struct) {
        ArrayList<Object> structStack = new ArrayList<Object>();
        structStack.add(struct);
        String name = null;
        block8: while (true) {
            JsonParser.Event e = p.next();
            JsonValue value = null;
            switch (e) {
                case START_ARRAY: {
                    Cloneable newStruct = new CookJsonArray();
                    if (struct instanceof JsonArray) {
                        ((JsonArray)struct).add((Object)newStruct);
                    } else {
                        ((JsonObject)struct).put((Object)name, (Object)newStruct);
                    }
                    struct = newStruct;
                    structStack.add(newStruct);
                    continue block8;
                }
                case START_OBJECT: {
                    Cloneable newStruct = new CookJsonObject();
                    if (struct instanceof JsonArray) {
                        ((JsonArray)struct).add((Object)newStruct);
                    } else {
                        ((JsonObject)struct).put((Object)name, (Object)newStruct);
                    }
                    struct = newStruct;
                    structStack.add(newStruct);
                    continue block8;
                }
                case KEY_NAME: {
                    name = p.getString();
                    continue block8;
                }
                case END_ARRAY: {
                    value = (JsonValue)structStack.remove(structStack.size() - 1);
                    if (!(value instanceof JsonArray)) {
                        throw new IllegalStateException();
                    }
                    if (structStack.isEmpty()) {
                        return;
                    }
                    struct = (JsonStructure)structStack.get(structStack.size() - 1);
                    continue block8;
                }
                case END_OBJECT: {
                    value = (JsonValue)structStack.remove(structStack.size() - 1);
                    if (!(value instanceof JsonObject)) {
                        throw new IllegalStateException();
                    }
                    if (structStack.isEmpty()) {
                        return;
                    }
                    struct = (JsonStructure)structStack.get(structStack.size() - 1);
                    continue block8;
                }
                case VALUE_TRUE: 
                case VALUE_FALSE: 
                case VALUE_NULL: 
                case VALUE_NUMBER: 
                case VALUE_STRING: {
                    value = p.getValue();
                }
            }
            if (struct instanceof JsonArray) {
                ((JsonArray)struct).add((Object)value);
                continue;
            }
            ((JsonObject)struct).put((Object)name, (Object)value);
            name = null;
        }
    }

    public static JsonStructure getStructure(CookJsonParser p) {
        JsonParser.Event e = p.getEvent();
        switch (e) {
            case START_ARRAY: {
                CookJsonArray v = new CookJsonArray();
                Utils.addStructure(p, (JsonStructure)v);
                return v;
            }
            case START_OBJECT: {
                CookJsonObject v = new CookJsonObject();
                Utils.addStructure(p, (JsonStructure)v);
                return v;
            }
        }
        throw new IllegalStateException();
    }

    public static void convert(JsonParser p, JsonGenerator g) {
        CookJsonParser p2 = null;
        CookJsonGenerator g2 = null;
        if (p instanceof CookJsonParser) {
            p2 = (CookJsonParser)p;
        }
        if (g instanceof CookJsonGenerator) {
            g2 = (CookJsonGenerator)g;
        }
        String name = null;
        try {
            block17: while (true) {
                JsonParser.Event e = p.next();
                switch (e) {
                    case START_ARRAY: {
                        if (name == null) {
                            g.writeStartArray();
                            break;
                        }
                        g.writeStartArray(name);
                        name = null;
                        break;
                    }
                    case START_OBJECT: {
                        if (name == null) {
                            g.writeStartObject();
                            break;
                        }
                        g.writeStartObject(name);
                        name = null;
                        break;
                    }
                    case KEY_NAME: {
                        name = p.getString();
                        break;
                    }
                    case END_ARRAY: 
                    case END_OBJECT: {
                        g.writeEnd();
                        name = null;
                        break;
                    }
                    case VALUE_TRUE: {
                        if (name == null) {
                            g.write(true);
                            break;
                        }
                        g.write(name, true);
                        name = null;
                        break;
                    }
                    case VALUE_FALSE: {
                        if (name == null) {
                            g.write(false);
                            break;
                        }
                        g.write(name, false);
                        name = null;
                        break;
                    }
                    case VALUE_NULL: {
                        if (name == null) {
                            g.writeNull();
                            break;
                        }
                        g.writeNull(name);
                        name = null;
                        break;
                    }
                    case VALUE_NUMBER: {
                        BigDecimal value = p.getBigDecimal();
                        if (p.isIntegralNumber()) {
                            try {
                                if (name == null) {
                                    g.write(value.intValueExact());
                                    break;
                                }
                                g.write(name, value.intValueExact());
                                name = null;
                            }
                            catch (ArithmeticException ex) {
                                try {
                                    if (name == null) {
                                        g.write(value.longValueExact());
                                        break;
                                    }
                                    g.write(name, value.longValueExact());
                                    name = null;
                                    break;
                                }
                                catch (ArithmeticException ex2) {
                                    if (name == null) {
                                        g.write(value.toBigInteger());
                                        break;
                                    }
                                    g.write(name, value.toBigInteger());
                                    name = null;
                                }
                            }
                            continue block17;
                        }
                        if (name == null) {
                            g.write(value);
                            break;
                        }
                        g.write(name, value);
                        name = null;
                        break;
                    }
                    case VALUE_STRING: {
                        if (p2 != null && g2 != null && p2.isBinary()) {
                            if (name == null) {
                                g2.write(p2.getBytes());
                                break;
                            }
                            g2.write(name, p2.getBytes());
                            name = null;
                            break;
                        }
                        if (name == null) {
                            g.write(p.getString());
                            break;
                        }
                        g.write(name, p.getString());
                        name = null;
                        break;
                    }
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    public static String getString(File file) {
        try {
            int len;
            StringBuilder buf = new StringBuilder();
            char[] chars = new char[8192];
            InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(file), BOM.utf8);
            while ((len = r.read(chars)) > 0) {
                buf.append(chars, 0, len);
            }
            r.close();
            return buf.toString();
        }
        catch (Exception ex) {
            return null;
        }
    }
}

