/*
 * Decompiled with CFR 0.152.
 */
package org.yuanheng.cookjson;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import javax.json.JsonValue;
import javax.json.stream.JsonLocation;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParsingException;
import org.yuanheng.cookjson.BOM;
import org.yuanheng.cookjson.CommentJsonParser;
import org.yuanheng.cookjson.CookJsonParser;
import org.yuanheng.cookjson.JsonLocationImpl;
import org.yuanheng.cookjson.Utils;
import org.yuanheng.cookjson.value.CookJsonBigDecimal;
import org.yuanheng.cookjson.value.CookJsonString;

public class UTF8TextJsonParser
implements CookJsonParser,
CommentJsonParser {
    private static final int START = 1;
    private static final int VALUE = 2;
    private static final int FIELD = 3;
    private static final int READ_SIZE = 8192;
    private boolean m_allowComments;
    private final InputStream m_in;
    private byte[] m_appendBuf = new byte[8193];
    private int m_appendPos;
    private long m_line;
    private long m_offset;
    private long m_column;
    private long savedLine;
    private long savedColumn;
    private long savedOffset;
    private final byte[] m_readBuf;
    private int m_readPos = 0;
    private int m_readMax = 0;
    private final ArrayList<Boolean> m_states = new ArrayList();
    private int m_state = 0;
    private int m_lastToken;
    private boolean m_int;
    private JsonParser.Event m_event;
    private boolean m_simple;
    private int m_start;
    private int m_len;

    public UTF8TextJsonParser(InputStream is) {
        this(is, 8193);
    }

    public UTF8TextJsonParser(InputStream is, int bufferSize) {
        this.m_readBuf = new byte[bufferSize];
        this.m_in = is;
        this.m_line = 1L;
        this.m_column = 1L;
    }

    private void saveLocation() {
        this.savedLine = this.m_line;
        this.savedOffset = this.m_offset;
        this.savedColumn = this.m_column;
    }

    private void append(byte ch) {
        if (this.m_appendPos >= this.m_appendBuf.length) {
            int len = this.m_appendBuf.length;
            byte[] newBuffer = new byte[len + len / 2];
            System.arraycopy(this.m_appendBuf, 0, newBuffer, 0, len);
            this.m_appendBuf = newBuffer;
        }
        this.m_appendBuf[this.m_appendPos++] = ch;
    }

    private IllegalStateException stateError(String function) {
        return new IllegalStateException(function + " cannot be called at the current state: " + this.m_event + ".");
    }

    private JsonParsingException ioError(String msg) {
        JsonLocationImpl location = new JsonLocationImpl();
        location.m_lineNumber = this.m_line;
        location.m_columnNumber = this.m_column - 1L;
        location.m_streamOffset = this.m_offset - 1L;
        return new JsonParsingException("Parsing error at " + location.toString() + ": " + msg, (JsonLocation)location);
    }

    private JsonParsingException eofError() {
        JsonLocation location = this.getCurrentLocation();
        return new JsonParsingException("Parsing error at " + location.toString() + ": unexpected eof.", location);
    }

    private JsonParsingException unexpected(byte ch) {
        String charStr;
        switch (ch) {
            case 8: {
                charStr = "\\b";
                break;
            }
            case 9: {
                charStr = "\\t";
                break;
            }
            case 10: {
                charStr = "\\n";
                break;
            }
            case 13: {
                charStr = "\\r";
                break;
            }
            case 12: {
                charStr = "\\f";
                break;
            }
            case 92: {
                charStr = "\\\\";
                break;
            }
            case 39: {
                charStr = "\\'";
                break;
            }
            default: {
                if (ch < 32 || ch > 127) {
                    String hex = Integer.toHexString(ch);
                    charStr = "\\u" + "0000".substring(hex.length()) + hex;
                    break;
                }
                charStr = Character.toString((char)ch);
            }
        }
        return this.ioError("unexpected character '" + charStr + "'");
    }

    private byte read() throws IOException {
        if (this.m_readPos >= this.m_readMax) {
            this.fill();
        }
        ++this.m_offset;
        ++this.m_column;
        return this.m_readBuf[this.m_readPos++];
    }

    private void unread() {
        --this.m_readPos;
        --this.m_offset;
        --this.m_column;
    }

    private void fill() throws IOException {
        byte[] readBuf = this.m_readBuf;
        this.m_readPos = 0;
        this.m_readMax = this.m_in.read(readBuf, 0, readBuf.length - 1);
        if (this.m_readMax <= 0) {
            throw this.eofError();
        }
        readBuf[this.m_readMax] = 0;
    }

    private void readLineComment() throws IOException {
        byte[] readBuf = this.m_readBuf;
        int readPos = this.m_readPos;
        while (true) {
            int l;
            byte ch;
            if ((ch = readBuf[readPos++]) == 10) {
                this.m_offset += (long)(readPos - this.m_readPos);
                this.m_column = 1L;
                ++this.m_line;
                this.m_readPos = readPos;
                return;
            }
            if (ch != 0) continue;
            if (readPos <= this.m_readMax) {
                l = readPos - this.m_readPos;
                this.m_offset += (long)l;
                this.m_column += (long)l;
                throw this.unexpected(ch);
            }
            l = readPos - this.m_readPos - 1;
            this.m_offset += (long)l;
            this.m_column += (long)l;
            this.fill();
            readPos = 0;
        }
    }

    private void readBlockComment() throws IOException {
        byte[] readBuf = this.m_readBuf;
        int readPos = this.m_readPos;
        int len = 0;
        while (true) {
            byte ch = readBuf[readPos++];
            ++len;
            switch (ch) {
                case 10: {
                    this.m_offset += (long)len;
                    this.m_column = 1L;
                    ++this.m_line;
                    len = 0;
                    break;
                }
                case 42: {
                    byte nextChar;
                    if (readPos < this.m_readMax) {
                        nextChar = readBuf[readPos];
                    } else {
                        this.fill();
                        readPos = 0;
                        nextChar = readBuf[readPos];
                    }
                    if (nextChar != 47) break;
                    this.m_offset += (long)(len + 1);
                    this.m_column += (long)(len + 1);
                    this.m_readPos = readPos + 1;
                    return;
                }
                case 0: {
                    if (readPos <= this.m_readMax) {
                        this.m_offset += (long)len;
                        this.m_column += (long)len;
                        throw this.unexpected(ch);
                    }
                    --len;
                    this.fill();
                    readPos = 0;
                }
            }
        }
    }

    private void readComment() throws IOException {
        byte ch = this.read();
        if (ch == 47) {
            this.readLineComment();
        } else if (ch == 42) {
            this.readBlockComment();
        } else {
            --this.m_offset;
            --this.m_column;
            throw this.unexpected((byte)47);
        }
    }

    private void scanUnexpected(byte ch) throws IOException {
        if (!this.m_allowComments || ch != 47) {
            throw this.unexpected(ch);
        }
        this.readComment();
    }

    private void expect(String str) throws IOException {
        int len = str.length();
        if (this.m_readPos + len >= this.m_readMax) {
            for (int i = 0; i < len; ++i) {
                byte ch = this.read();
                if (ch == str.charAt(i)) continue;
                throw this.ioError("expecting '" + ch + "'");
            }
        } else {
            byte[] readBuf = this.m_readBuf;
            int readPos = this.m_readPos;
            for (int i = 0; i < len; ++i) {
                byte ch;
                if ((ch = readBuf[readPos++]) == str.charAt(i)) continue;
                throw this.ioError("expecting '" + ch + "'");
            }
            this.m_readPos = readPos;
            this.m_offset += (long)len;
            this.m_column += (long)len;
        }
    }

    private void readNegative() throws IOException {
        this.m_start = this.m_readPos - 1;
        this.m_appendBuf[0] = 45;
        this.m_appendPos = 1;
        byte ch = this.m_readBuf[this.m_readPos++];
        ++this.m_offset;
        ++this.m_column;
        if (ch == 0) {
            if (this.m_readPos <= this.m_readMax) {
                throw this.unexpected(ch);
            }
            this.fill();
            ch = this.m_readBuf[0];
            this.m_readPos = 1;
            if (ch < 48 || ch > 57) {
                throw this.unexpected(ch);
            }
            this.readNumber(ch);
            return;
        }
        if (ch < 48 || ch > 57) {
            throw this.unexpected(ch);
        }
        this.readFastNumber(ch);
    }

    private void readFastNumber(byte firstChar) throws IOException {
        int readPos;
        block25: {
            byte ch;
            byte[] readBuf;
            block24: {
                block23: {
                    this.m_simple = true;
                    this.m_int = true;
                    readBuf = this.m_readBuf;
                    readPos = this.m_readPos;
                    if (firstChar == 48) {
                        if ((ch = readBuf[readPos++]) != 46) {
                            if (ch == 0) {
                                this.readNumber(firstChar);
                                return;
                            }
                            if (this.m_appendPos > 0) {
                                ++this.m_offset;
                                ++this.m_column;
                                throw this.unexpected(ch);
                            }
                            this.m_len = 1;
                            return;
                        }
                    } else {
                        while ((ch = readBuf[readPos++]) >= 48) {
                            if (ch <= 57) {
                                continue;
                            }
                            break block23;
                        }
                        if (ch == 0) {
                            this.readNumber(firstChar);
                            return;
                        }
                    }
                }
                if (ch == 46) {
                    this.m_int = false;
                    if ((ch = readBuf[readPos++]) >= 48 && ch <= 57) {
                        while ((ch = readBuf[readPos++]) >= 48) {
                            if (ch <= 57) {
                                continue;
                            }
                            break block24;
                        }
                        if (ch == 0) {
                            this.readNumber(firstChar);
                            return;
                        }
                    } else {
                        if (ch == 0) {
                            this.readNumber(firstChar);
                            return;
                        }
                        int l = readPos - this.m_readPos;
                        this.m_offset += (long)l;
                        this.m_column += (long)l;
                        throw this.unexpected(ch);
                    }
                }
            }
            if (ch == 69 || ch == 101) {
                this.m_int = false;
                if ((ch = readBuf[readPos++]) == 43 || ch == 45) {
                    ch = readBuf[readPos++];
                }
                if (ch < 48 || ch > 57) {
                    if (ch == 0) {
                        this.readNumber(firstChar);
                        return;
                    }
                    int l = readPos - this.m_readPos;
                    this.m_offset += (long)l;
                    this.m_column += (long)l;
                    throw this.unexpected(ch);
                }
                while ((ch = readBuf[readPos++]) >= 48) {
                    if (ch <= 57) {
                        continue;
                    }
                    break block25;
                }
                if (ch == 0) {
                    if (readPos <= this.m_readMax) {
                        int l = readPos - this.m_readPos;
                        this.m_offset += (long)l;
                        this.m_column += (long)l;
                        throw this.unexpected(ch);
                    }
                    this.readNumber(firstChar);
                    return;
                }
            }
        }
        int l = readPos - this.m_readPos - 1;
        this.m_offset += (long)l;
        this.m_column += (long)l;
        this.m_readPos += l;
        this.m_len = this.m_readPos - this.m_start;
    }

    private void readNumber(byte firstChar) throws IOException {
        byte ch;
        this.m_simple = false;
        this.m_int = true;
        this.append(firstChar);
        if (firstChar == 48) {
            ch = this.read();
            if (ch != 46) {
                if (this.m_appendBuf[0] == 45) {
                    throw this.unexpected(ch);
                }
                this.unread();
                return;
            }
        } else {
            while ((ch = this.read()) >= 48 && ch <= 57) {
                this.append(ch);
            }
        }
        if (ch == 46) {
            this.append(ch);
            this.m_int = false;
            ch = this.read();
            if (ch >= 48 && ch <= 57) {
                this.append(ch);
                while ((ch = this.read()) >= 48 && ch <= 57) {
                    this.append(ch);
                }
            } else {
                throw this.unexpected(ch);
            }
        }
        if (ch == 69 || ch == 101) {
            this.append(ch);
            this.m_int = false;
            ch = this.read();
            if (ch == 43 || ch == 45) {
                this.append(ch);
                ch = this.read();
            }
            if (ch >= 48 && ch <= 57) {
                this.append(ch);
            } else {
                throw this.unexpected(ch);
            }
            while ((ch = this.read()) >= 48 && ch <= 57) {
                this.append(ch);
            }
        }
        this.unread();
    }

    private void readEscape() throws IOException {
        byte ch = this.read();
        switch (ch) {
            case 98: {
                this.append((byte)8);
                break;
            }
            case 102: {
                this.append((byte)12);
                break;
            }
            case 110: {
                this.append((byte)10);
                break;
            }
            case 114: {
                this.append((byte)13);
                break;
            }
            case 116: {
                this.append((byte)9);
                break;
            }
            case 34: 
            case 47: 
            case 92: {
                this.append(ch);
                break;
            }
            case 117: {
                int val = 0;
                for (int i = 0; i < 4; ++i) {
                    ch = this.read();
                    if (ch >= 48) {
                        int hex;
                        if (ch <= 57) {
                            hex = ch - 48;
                            val = val << 4 | hex;
                            continue;
                        }
                        if (ch >= 65) {
                            if (ch <= 70) {
                                hex = ch - 65 + 10;
                                val = val << 4 | hex;
                                continue;
                            }
                            if (ch >= 97 && ch <= 102) {
                                hex = ch - 97 + 10;
                                val = val << 4 | hex;
                                continue;
                            }
                        }
                    }
                    throw this.unexpected(ch);
                }
                this.append((byte)val);
                break;
            }
            default: {
                throw this.ioError("unknown escape sequence '\\" + (char)ch + "'");
            }
        }
    }

    private void readString() throws IOException {
        byte ch;
        int readPos;
        block4: {
            byte[] readBuf = this.m_readBuf;
            readPos = this.m_readPos;
            this.m_simple = true;
            this.m_start = readPos;
            while (true) {
                if ((ch = readBuf[readPos++]) > 92 || ch < 0) {
                    continue;
                }
                if (ch > 34) {
                    if (ch < 92) continue;
                    this.readComplexString(readPos - 1);
                    return;
                }
                if (ch < 32) break block4;
                if (ch >= 34) break;
            }
            int l = readPos - this.m_readPos;
            this.m_offset += (long)l;
            this.m_column += (long)l;
            this.m_readPos = readPos;
            this.m_len = l - 1;
            return;
        }
        if (ch == 0) {
            this.readComplexString(readPos - 1);
            return;
        }
        int l = readPos - this.m_readPos;
        this.m_offset += (long)l;
        this.m_column += (long)l;
        throw this.unexpected(ch);
    }

    private void readComplexString(int readPos) throws IOException {
        int l;
        byte ch;
        this.m_simple = false;
        byte[] readBuf = this.m_readBuf;
        int len = readPos - this.m_start;
        if (this.m_appendBuf.length < len) {
            int appendBufLen;
            for (appendBufLen = this.m_appendBuf.length; appendBufLen < len; appendBufLen += appendBufLen) {
            }
            this.m_appendBuf = new byte[appendBufLen];
        }
        System.arraycopy(readBuf, this.m_start, this.m_appendBuf, 0, len);
        this.m_appendPos = len;
        while (true) {
            if ((ch = readBuf[readPos++]) > 92 || ch < 0) {
                this.append(ch);
                continue;
            }
            if (ch > 34) {
                if (ch < 92) {
                    this.append(ch);
                    continue;
                }
                l = readPos - this.m_readPos;
                this.m_offset += (long)l;
                this.m_column += (long)l;
                this.m_readPos = readPos;
                this.readEscape();
                readPos = this.m_readPos;
                continue;
            }
            if (ch >= 32) {
                if (ch < 34) {
                    this.append(ch);
                    continue;
                }
                l = readPos - this.m_readPos;
                this.m_offset += (long)l;
                this.m_column += (long)l;
                this.m_readPos = readPos;
                return;
            }
            if (ch != 0) break;
            if (readPos <= this.m_readMax) {
                l = readPos - this.m_readPos;
                this.m_offset += (long)l;
                this.m_column += (long)l;
                throw this.unexpected(ch);
            }
            l = readPos - this.m_readPos - 1;
            this.m_offset += (long)l;
            this.m_column += (long)l;
            this.fill();
            readPos = 0;
        }
        l = readPos - this.m_readPos;
        this.m_offset += (long)l;
        this.m_column += (long)l;
        throw this.unexpected(ch);
    }

    private String getBufferString() {
        if (this.m_simple) {
            return new String(this.m_readBuf, this.m_start, this.m_len, BOM.utf8);
        }
        return new String(this.m_appendBuf, 0, this.m_appendPos, BOM.utf8);
    }

    @Override
    public JsonParser.Event getEvent() {
        return this.m_event;
    }

    @Override
    public JsonValue getValue() {
        switch (this.m_event) {
            case START_ARRAY: 
            case START_OBJECT: {
                return Utils.getStructure(this);
            }
            case END_ARRAY: 
            case END_OBJECT: 
            case KEY_NAME: {
                throw this.stateError("getValue()");
            }
            case VALUE_TRUE: {
                return JsonValue.TRUE;
            }
            case VALUE_FALSE: {
                return JsonValue.FALSE;
            }
            case VALUE_NULL: {
                return JsonValue.NULL;
            }
            case VALUE_NUMBER: {
                return new CookJsonBigDecimal(this.getBigDecimal());
            }
            case VALUE_STRING: {
                return new CookJsonString(this.getString());
            }
        }
        throw this.stateError("getValue()");
    }

    private void expectArrayObject() throws IOException {
        while (true) {
            byte ch = this.m_readBuf[this.m_readPos++];
            ++this.m_offset;
            ++this.m_column;
            if (ch == 91) {
                this.pushState(true);
                this.m_event = JsonParser.Event.START_ARRAY;
                this.m_lastToken = 1;
                return;
            }
            if (ch == 123) {
                this.pushState(false);
                this.m_event = JsonParser.Event.START_OBJECT;
                this.m_lastToken = 1;
                return;
            }
            if (ch == 32 || ch == 9 || ch == 13) continue;
            if (ch == 10) {
                this.m_column = 1L;
                ++this.m_line;
                continue;
            }
            if (ch == 0) {
                if (this.m_readPos <= this.m_readMax) {
                    throw this.unexpected(ch);
                }
                --this.m_offset;
                --this.m_column;
                this.fill();
                continue;
            }
            this.scanUnexpected(ch);
        }
    }

    private boolean expectCommaObject() throws IOException {
        while (true) {
            byte ch = this.m_readBuf[this.m_readPos++];
            ++this.m_offset;
            ++this.m_column;
            if (ch == 44) {
                return false;
            }
            if (ch == 125) {
                this.popState(false);
                this.m_event = JsonParser.Event.END_OBJECT;
                this.m_lastToken = 2;
                return true;
            }
            if (ch == 32 || ch == 9 || ch == 13) continue;
            if (ch == 10) {
                this.m_column = 1L;
                ++this.m_line;
                continue;
            }
            if (ch == 0) {
                if (this.m_readPos <= this.m_readMax) {
                    throw this.unexpected(ch);
                }
                --this.m_offset;
                --this.m_column;
                this.fill();
                continue;
            }
            this.scanUnexpected(ch);
        }
    }

    private boolean expectCommaArray() throws IOException {
        while (true) {
            byte ch = this.m_readBuf[this.m_readPos++];
            ++this.m_offset;
            ++this.m_column;
            if (ch == 44) {
                return false;
            }
            if (ch == 93) {
                this.popState(true);
                this.m_event = JsonParser.Event.END_ARRAY;
                this.m_lastToken = 2;
                return true;
            }
            if (ch == 32 || ch == 9 || ch == 13) continue;
            if (ch == 10) {
                this.m_column = 1L;
                ++this.m_line;
                continue;
            }
            if (ch == 0) {
                if (this.m_readPos <= this.m_readMax) {
                    throw this.unexpected(ch);
                }
                --this.m_offset;
                --this.m_column;
                this.fill();
                continue;
            }
            this.scanUnexpected(ch);
        }
    }

    private void expectColon() throws IOException {
        while (true) {
            byte ch = this.m_readBuf[this.m_readPos++];
            ++this.m_offset;
            ++this.m_column;
            if (ch == 58) {
                return;
            }
            if (ch == 32 || ch == 9 || ch == 13) continue;
            if (ch == 10) {
                this.m_column = 1L;
                ++this.m_line;
                continue;
            }
            if (ch == 0) {
                if (this.m_readPos <= this.m_readMax) {
                    throw this.unexpected(ch);
                }
                --this.m_offset;
                --this.m_column;
                this.fill();
                continue;
            }
            this.scanUnexpected(ch);
        }
    }

    private void expectKeyName() throws IOException {
        while (true) {
            byte ch = this.m_readBuf[this.m_readPos++];
            ++this.m_offset;
            ++this.m_column;
            if (ch == 34) {
                this.saveLocation();
                this.readString();
                this.m_event = JsonParser.Event.KEY_NAME;
                this.m_lastToken = 3;
                this.m_event = JsonParser.Event.KEY_NAME;
                return;
            }
            if (ch == 125) {
                this.popState(false);
                this.m_event = JsonParser.Event.END_OBJECT;
                this.m_lastToken = 2;
                return;
            }
            if (ch == 32 || ch == 9 || ch == 13) continue;
            if (ch == 10) {
                this.m_column = 1L;
                ++this.m_line;
                continue;
            }
            if (ch == 0) {
                if (this.m_readPos <= this.m_readMax) {
                    throw this.unexpected(ch);
                }
                --this.m_offset;
                --this.m_column;
                this.fill();
                continue;
            }
            this.scanUnexpected(ch);
        }
    }

    private void expectValue() throws IOException {
        block15: while (true) {
            byte ch = this.m_readBuf[this.m_readPos++];
            ++this.m_offset;
            ++this.m_column;
            switch (ch) {
                case 9: 
                case 13: {
                    continue block15;
                }
                case 10: {
                    this.m_column = 1L;
                    ++this.m_line;
                    continue block15;
                }
                case 32: {
                    continue block15;
                }
                case 34: {
                    this.saveLocation();
                    this.readString();
                    this.m_lastToken = 2;
                    this.m_event = JsonParser.Event.VALUE_STRING;
                    return;
                }
                case 45: {
                    this.readNegative();
                    this.m_event = JsonParser.Event.VALUE_NUMBER;
                    this.m_lastToken = 2;
                    return;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.m_appendPos = 0;
                    this.m_start = this.m_readPos - 1;
                    this.readFastNumber(ch);
                    this.m_event = JsonParser.Event.VALUE_NUMBER;
                    this.m_lastToken = 2;
                    return;
                }
                case 91: {
                    this.pushState(true);
                    this.m_event = JsonParser.Event.START_ARRAY;
                    this.m_lastToken = 1;
                    return;
                }
                case 93: {
                    this.popState(true);
                    this.m_event = JsonParser.Event.END_ARRAY;
                    this.m_lastToken = 2;
                    return;
                }
                case 102: {
                    this.expect("alse");
                    this.m_event = JsonParser.Event.VALUE_FALSE;
                    this.m_lastToken = 2;
                    return;
                }
                case 110: {
                    this.expect("ull");
                    this.m_event = JsonParser.Event.VALUE_NULL;
                    this.m_lastToken = 2;
                    return;
                }
                case 116: {
                    this.expect("rue");
                    this.m_event = JsonParser.Event.VALUE_TRUE;
                    this.m_lastToken = 2;
                    return;
                }
                case 123: {
                    this.pushState(false);
                    this.m_event = JsonParser.Event.START_OBJECT;
                    this.m_lastToken = 1;
                    return;
                }
                case 0: {
                    if (this.m_readPos <= this.m_readMax) {
                        throw this.unexpected(ch);
                    }
                    --this.m_offset;
                    --this.m_column;
                    this.fill();
                    continue block15;
                }
            }
            this.scanUnexpected(ch);
        }
    }

    public JsonParser.Event next() {
        try {
            int state = this.m_state;
            if (state == 3) {
                int lastToken = this.m_lastToken;
                if (lastToken == 3) {
                    this.expectColon();
                    this.expectValue();
                    return this.m_event;
                }
                if (lastToken == 2 && this.expectCommaObject()) {
                    return this.m_event;
                }
                this.expectKeyName();
                return this.m_event;
            }
            if (state == 1) {
                if (this.m_lastToken == 2 && this.expectCommaArray()) {
                    return this.m_event;
                }
                this.expectValue();
                return this.m_event;
            }
            if (state == 0) {
                this.expectArrayObject();
                return this.m_event;
            }
            if (state == -1) {
                throw new NoSuchElementException();
            }
            throw new IllegalStateException();
        }
        catch (IOException ex) {
            throw new JsonParsingException(ex.getMessage(), (Throwable)ex, this.getCurrentLocation());
        }
    }

    public boolean hasNext() {
        return this.m_state != -1;
    }

    public boolean isIntegralNumber() {
        if (this.m_event != JsonParser.Event.VALUE_NUMBER) {
            throw this.stateError("isIntegralNumber()");
        }
        return this.m_int || this.getBigDecimal().scale() == 0;
    }

    public int getInt() {
        if (this.m_event != JsonParser.Event.VALUE_NUMBER) {
            throw this.stateError("getInt()");
        }
        if (this.m_int) {
            int len;
            int n = len = this.m_simple ? this.m_len : this.m_appendPos;
            if (len < 10 || len < 11 && this.m_appendBuf[0] == 45) {
                return Integer.valueOf(this.getBufferString());
            }
        }
        return new BigDecimal(this.getBufferString()).intValue();
    }

    public long getLong() {
        if (this.m_event != JsonParser.Event.VALUE_NUMBER) {
            throw this.stateError("getLong()");
        }
        if (this.m_int) {
            int len;
            int n = len = this.m_simple ? this.m_len : this.m_appendPos;
            if (len < 19 || len < 20 && this.m_appendBuf[0] == 45) {
                return Long.valueOf(this.getBufferString());
            }
        }
        return new BigDecimal(this.getBufferString()).longValue();
    }

    public BigDecimal getBigDecimal() {
        if (this.m_event != JsonParser.Event.VALUE_NUMBER) {
            throw this.stateError("getBigDecimal()");
        }
        return new BigDecimal(this.getBufferString());
    }

    private JsonLocation getCurrentLocation() {
        JsonLocationImpl location = new JsonLocationImpl();
        location.m_columnNumber = this.m_column;
        location.m_streamOffset = this.m_offset;
        location.m_lineNumber = this.m_line;
        return location;
    }

    public JsonLocation getLocation() {
        JsonLocationImpl location = new JsonLocationImpl();
        long diff = 0L;
        switch (this.m_event) {
            case START_ARRAY: 
            case START_OBJECT: 
            case END_ARRAY: 
            case END_OBJECT: {
                diff = 1L;
                break;
            }
            case VALUE_NUMBER: {
                if (this.m_simple) {
                    diff = this.m_len;
                    break;
                }
                diff = this.m_appendPos;
                break;
            }
            case KEY_NAME: 
            case VALUE_STRING: {
                location.m_columnNumber = this.savedColumn - 1L;
                location.m_streamOffset = this.savedOffset - 1L;
                location.m_lineNumber = this.savedLine;
                return location;
            }
            case VALUE_FALSE: {
                diff = 5L;
                break;
            }
            case VALUE_TRUE: 
            case VALUE_NULL: {
                diff = 4L;
            }
        }
        location.m_columnNumber = this.m_column - diff;
        location.m_streamOffset = this.m_offset - diff;
        location.m_lineNumber = this.m_line;
        return location;
    }

    public String getString() {
        if (this.m_event == null) {
            throw this.stateError("getString()");
        }
        switch (this.m_event) {
            case KEY_NAME: 
            case VALUE_NUMBER: 
            case VALUE_STRING: {
                return this.getBufferString();
            }
        }
        throw this.stateError("getString()");
    }

    @Override
    public boolean isBinary() {
        if (this.m_event != JsonParser.Event.VALUE_STRING) {
            throw this.stateError("isBinary()");
        }
        return false;
    }

    @Override
    public byte[] getBytes() {
        if (this.m_event != JsonParser.Event.VALUE_STRING) {
            throw this.stateError("getBytes()");
        }
        throw new IllegalStateException("The current string value is not binary.");
    }

    public void close() {
        try {
            this.m_in.close();
        }
        catch (IOException ex) {
            throw new JsonParsingException(ex.getMessage(), (Throwable)ex, this.getCurrentLocation());
        }
    }

    private void pushState(boolean isArray) {
        if (this.m_state != 0) {
            this.m_states.add(this.m_state == 1);
        }
        this.m_state = isArray ? 1 : 3;
    }

    private void popState(boolean isArrayEnd) {
        boolean b;
        boolean isArray;
        boolean bl = isArray = this.m_state == 1;
        if (isArrayEnd != isArray) {
            throw new IllegalStateException();
        }
        this.m_state = this.m_states.isEmpty() ? -1 : ((b = this.m_states.remove(this.m_states.size() - 1).booleanValue()) ? 1 : 3);
    }

    @Override
    public boolean isAllowComments() {
        return this.m_allowComments;
    }

    @Override
    public void setAllowComments(boolean allowComments) {
        this.m_allowComments = allowComments;
    }
}

