/*
 * Decompiled with CFR 0.152.
 */
package org.yuanheng.cookjson;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerationException;
import javax.json.stream.JsonGenerator;
import org.yuanheng.cookjson.BOM;
import org.yuanheng.cookjson.Base64;
import org.yuanheng.cookjson.CookJsonGenerator;
import org.yuanheng.cookjson.DoubleUtils;
import org.yuanheng.cookjson.Quote;
import org.yuanheng.cookjson.value.CookJsonBinary;

public class TextJsonGenerator
implements CookJsonGenerator {
    boolean m_keyNameEscaped;
    final Writer m_out;
    final ArrayList<Boolean> m_states = new ArrayList();
    int m_state = 0;
    boolean m_first = true;
    static final int m_max = 8192;
    final char[] m_buffer = new char[8193];
    int m_pos;
    static final int m_valueLen = 22;
    final char[] m_valueBuffer = new char[22];
    int m_binaryFormat;

    public TextJsonGenerator(OutputStream os) {
        this.m_out = new OutputStreamWriter(os, BOM.utf8);
    }

    public TextJsonGenerator(Writer out) {
        this.m_out = out;
    }

    void writeComma() throws IOException {
        if (this.m_first) {
            this.m_first = false;
        } else {
            this.w(',');
        }
    }

    void writeName(String name) throws IOException {
        if (this.m_first) {
            this.m_first = false;
        } else {
            this.w(',');
        }
        if (this.m_keyNameEscaped) {
            this.w(name);
        } else {
            this.quote(name);
        }
        this.w(':');
    }

    void quote(String str) throws IOException {
        int i;
        int strLength = str.length();
        char[] esc = this.m_valueBuffer;
        int start = 0;
        this.w('\"');
        block7: for (i = 0; i < strLength; ++i) {
            int len;
            char ch = str.charAt(i);
            if (ch > '\\') continue;
            if (ch > '\"') {
                if (ch < '\\') continue;
                len = i - start + 1;
                this.w(str, start, len);
                start = i;
                continue;
            }
            if (ch >= ' ') {
                if (ch < '\"') continue;
                len = i - start;
                if (len > 0) {
                    this.w(str, start, len);
                }
                this.w('\\');
                start = i;
                continue;
            }
            len = i - start;
            if (len > 0) {
                this.w(str, start, len);
            }
            start = i + 1;
            if (esc[0] == '\u0000') {
                esc[0] = 92;
                esc[2] = 48;
                esc[3] = 48;
            }
            switch (ch) {
                case '\b': {
                    esc[1] = 98;
                    this.w(esc, 0, 2);
                    continue block7;
                }
                case '\t': {
                    esc[1] = 116;
                    this.w(esc, 0, 2);
                    continue block7;
                }
                case '\n': {
                    esc[1] = 110;
                    this.w(esc, 0, 2);
                    continue block7;
                }
                case '\r': {
                    esc[1] = 114;
                    this.w(esc, 0, 2);
                    continue block7;
                }
                case '\f': {
                    esc[1] = 102;
                    this.w(esc, 0, 2);
                    continue block7;
                }
                default: {
                    esc[1] = 117;
                    esc[4] = Quote.hex[ch >> 4 & 0xF];
                    esc[5] = Quote.hex[ch & 0xF];
                    this.w(esc, 0, 6);
                }
            }
        }
        int len = i - start;
        if (len > 0) {
            this.w(str, start, len);
        }
        this.w('\"');
    }

    void base64Encode(byte[] value) throws IOException {
        char[] chars = Base64.CHARS;
        this.w('\"');
        char[] buf = this.m_buffer;
        int pos = this.m_pos;
        int max = 8188;
        int len = value.length;
        for (int i = 0; i < len; i += 3) {
            if (pos >= 8188) {
                this.m_out.write(buf, 0, pos);
                pos = 0;
            }
            int b = (value[i] & 0xFC) >> 2;
            buf[pos++] = chars[b];
            b = (value[i] & 3) << 4;
            if (i + 1 < len) {
                buf[pos++] = chars[b |= (value[i + 1] & 0xF0) >> 4];
                b = (value[i + 1] & 0xF) << 2;
                if (i + 2 < len) {
                    buf[pos++] = chars[b |= (value[i + 2] & 0xC0) >> 6];
                    b = value[i + 2] & 0x3F;
                    buf[pos++] = chars[b];
                    continue;
                }
                buf[pos++] = chars[b];
                buf[pos++] = 61;
                continue;
            }
            buf[pos++] = chars[b];
            buf[pos++] = 61;
            buf[pos++] = 61;
        }
        this.m_pos = pos;
        this.w('\"');
    }

    void hexEncode(byte[] value) throws IOException {
        char[] hex = Quote.hex;
        this.w('\"');
        char[] buf = this.m_buffer;
        int pos = this.m_pos;
        int max = 8190;
        for (byte b : value) {
            if (pos >= 8190) {
                this.m_out.write(buf, 0, pos);
                pos = 0;
            }
            buf[pos++] = hex[b >> 4 & 0xF];
            buf[pos++] = hex[b & 0xF];
        }
        this.m_pos = pos;
        this.w('\"');
    }

    void w(char[] chars, int offset, int length) throws IOException {
        int pos = this.m_pos;
        char[] buf = this.m_buffer;
        if (pos + length < 8192) {
            for (int i = 0; i < length; ++i) {
                buf[pos++] = chars[offset++];
            }
            this.m_pos = pos;
            return;
        }
        int len = 8192 - pos;
        for (int i = 0; i < len; ++i) {
            buf[pos++] = chars[offset++];
        }
        this.m_out.write(buf, 0, 8192);
        length -= len;
        while (length > 8192) {
            this.m_out.write(chars, offset, 8192);
            offset += 8192;
            length -= 8192;
        }
        for (int i = 0; i < length; ++i) {
            buf[i] = chars[offset++];
        }
        this.m_pos = length;
    }

    void w(String str) throws IOException {
        this.w(str, 0, str.length());
    }

    void w(String str, int offset, int length) throws IOException {
        int pos = this.m_pos;
        char[] buf = this.m_buffer;
        if (pos + length < 8192) {
            str.getChars(offset, offset + length, buf, pos);
            this.m_pos += length;
            return;
        }
        int len = 8192 - pos;
        str.getChars(offset, offset + len, buf, pos);
        this.m_out.write(buf, 0, 8192);
        offset += len;
        length -= len;
        pos = 0;
        while (length > 8192) {
            this.m_out.write(str, offset, 8192);
            offset += 8192;
            length -= 8192;
        }
        if (length > 0) {
            str.getChars(offset, offset + length, buf, 0);
        }
        this.m_pos = length;
    }

    void w(char ch) throws IOException {
        char[] buf = this.m_buffer;
        int pos = this.m_pos;
        buf[pos++] = ch;
        if (pos >= 8192) {
            this.m_out.write(buf, 0, pos);
            this.m_pos = 0;
        } else {
            this.m_pos = pos;
        }
    }

    void wi(int value) throws IOException {
        boolean negative;
        char[] buf = this.m_valueBuffer;
        int pos = 22;
        if (value < 0) {
            if (value == Integer.MIN_VALUE) {
                this.w("-2147483648");
                return;
            }
            negative = true;
            value = -value;
        } else {
            negative = false;
        }
        char[] digits = Quote.hex;
        do {
            int v = value / 10;
            int r = value % 10;
            value = v;
            buf[--pos] = digits[r];
        } while (value > 0);
        if (negative) {
            buf[--pos] = 45;
        }
        this.w(buf, pos, 22 - pos);
    }

    JsonGenerator writeValue(JsonValue value) throws IOException {
        switch (value.getValueType()) {
            case ARRAY: {
                JsonArray array = (JsonArray)value;
                this.w('[');
                this.m_first = true;
                for (JsonValue v : array) {
                    this.writeComma();
                    this.writeValue(v);
                }
                this.w(']');
                this.m_first = false;
                break;
            }
            case OBJECT: {
                JsonObject obj = (JsonObject)value;
                this.w('{');
                this.m_first = true;
                for (Map.Entry entry : obj.entrySet()) {
                    JsonValue v = (JsonValue)entry.getValue();
                    this.writeName((String)entry.getKey());
                    this.writeValue(v);
                }
                this.w('}');
                this.m_first = false;
                break;
            }
            case NULL: {
                this.w("null");
                break;
            }
            case NUMBER: {
                this.w(value.toString());
                break;
            }
            case STRING: {
                if (value instanceof CookJsonBinary) {
                    byte[] bytes = ((CookJsonBinary)value).getBytes();
                    if (this.m_binaryFormat == 0) {
                        this.base64Encode(bytes);
                        break;
                    }
                    this.hexEncode(bytes);
                    break;
                }
                this.quote(((JsonString)value).getString());
                break;
            }
            case TRUE: {
                this.w("true");
                break;
            }
            case FALSE: {
                this.w("false");
            }
        }
        return this;
    }

    public JsonGenerator writeStartObject() {
        if (this.m_state != 0 && this.m_state != 1) {
            throw new JsonGenerationException("This method is not called within a valid context.");
        }
        try {
            this.writeComma();
            this.w('{');
            this.pushState(false);
            this.m_first = true;
            return this;
        }
        catch (IOException ex) {
            throw new JsonGenerationException(ex.getMessage(), (Throwable)ex);
        }
    }

    public JsonGenerator writeStartObject(String name) {
        if (this.m_state != 2) {
            throw new JsonGenerationException("This method is not called within an object context.");
        }
        try {
            this.writeName(name);
            this.w('{');
            this.pushState(false);
            this.m_first = true;
            return this;
        }
        catch (IOException ex) {
            throw new JsonGenerationException(ex.getMessage(), (Throwable)ex);
        }
    }

    public JsonGenerator writeStartArray() {
        if (this.m_state != 0 && this.m_state != 1) {
            throw new JsonGenerationException("This method is not called within a valid context.");
        }
        try {
            this.writeComma();
            this.w('[');
            this.pushState(true);
            this.m_first = true;
            return this;
        }
        catch (IOException ex) {
            throw new JsonGenerationException(ex.getMessage(), (Throwable)ex);
        }
    }

    public JsonGenerator writeStartArray(String name) {
        if (this.m_state != 2) {
            throw new JsonGenerationException("This method is not called within an object context.");
        }
        try {
            this.writeName(name);
            this.w('[');
            this.pushState(true);
            this.m_first = true;
            return this;
        }
        catch (IOException ex) {
            throw new JsonGenerationException(ex.getMessage(), (Throwable)ex);
        }
    }

    public JsonGenerator write(String name, JsonValue value) {
        if (this.m_state != 2) {
            throw new JsonGenerationException("This method is not called within an object context.");
        }
        try {
            this.writeName(name);
            this.writeValue(value);
            return this;
        }
        catch (IOException ex) {
            throw new JsonGenerationException(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public JsonGenerator write(String name, byte[] value) {
        if (this.m_state != 2) {
            throw new JsonGenerationException("This method is not called within an object context.");
        }
        try {
            this.writeName(name);
            if (this.m_binaryFormat == 0) {
                this.base64Encode(value);
            } else {
                this.hexEncode(value);
            }
            return this;
        }
        catch (IOException ex) {
            throw new JsonGenerationException(ex.getMessage(), (Throwable)ex);
        }
    }

    public JsonGenerator write(String name, String value) {
        if (this.m_state != 2) {
            throw new JsonGenerationException("This method is not called within an object context.");
        }
        try {
            this.writeName(name);
            this.quote(value);
            return this;
        }
        catch (IOException ex) {
            throw new JsonGenerationException(ex.getMessage(), (Throwable)ex);
        }
    }

    public JsonGenerator write(String name, BigInteger value) {
        if (this.m_state != 2) {
            throw new JsonGenerationException("This method is not called within an object context.");
        }
        try {
            this.writeName(name);
            this.w(value.toString());
            return this;
        }
        catch (IOException ex) {
            throw new JsonGenerationException(ex.getMessage(), (Throwable)ex);
        }
    }

    public JsonGenerator write(String name, BigDecimal value) {
        if (this.m_state != 2) {
            throw new JsonGenerationException("This method is not called within an object context.");
        }
        try {
            this.writeName(name);
            this.w(value.toString());
            return this;
        }
        catch (IOException ex) {
            throw new JsonGenerationException(ex.getMessage(), (Throwable)ex);
        }
    }

    public JsonGenerator write(String name, int value) {
        if (this.m_state != 2) {
            throw new JsonGenerationException("This method is not called within an object context.");
        }
        try {
            this.writeName(name);
            this.wi(value);
            return this;
        }
        catch (IOException ex) {
            throw new JsonGenerationException(ex.getMessage(), (Throwable)ex);
        }
    }

    public JsonGenerator write(String name, long value) {
        if (this.m_state != 2) {
            throw new JsonGenerationException("This method is not called within an object context.");
        }
        try {
            this.writeName(name);
            this.w(Long.toString(value));
            return this;
        }
        catch (IOException ex) {
            throw new JsonGenerationException(ex.getMessage(), (Throwable)ex);
        }
    }

    public JsonGenerator write(String name, double value) {
        if (this.m_state != 2) {
            throw new JsonGenerationException("This method is not called within an object context.");
        }
        try {
            this.writeName(name);
            this.w(DoubleUtils.toString(value));
            return this;
        }
        catch (IOException ex) {
            throw new JsonGenerationException(ex.getMessage(), (Throwable)ex);
        }
    }

    public JsonGenerator write(String name, boolean value) {
        if (this.m_state != 2) {
            throw new JsonGenerationException("This method is not called within an object context.");
        }
        try {
            this.writeName(name);
            this.w(value ? "true" : "false");
            return this;
        }
        catch (IOException ex) {
            throw new JsonGenerationException(ex.getMessage(), (Throwable)ex);
        }
    }

    public JsonGenerator writeNull(String name) {
        if (this.m_state != 2) {
            throw new JsonGenerationException("This method is not called within an object context.");
        }
        try {
            this.writeName(name);
            this.w("null");
            return this;
        }
        catch (IOException ex) {
            throw new JsonGenerationException(ex.getMessage(), (Throwable)ex);
        }
    }

    public JsonGenerator writeEnd() {
        if (this.m_state == -1) {
            throw new JsonGenerationException("This method is not called within a valid context.");
        }
        boolean isArray = this.popState();
        this.m_first = false;
        char ch = isArray ? (char)']' : '}';
        try {
            this.w(ch);
        }
        catch (IOException ex) {
            throw new JsonGenerationException(ex.getMessage(), (Throwable)ex);
        }
        return this;
    }

    public JsonGenerator write(JsonValue value) {
        if (this.m_state != 1) {
            if (this.m_state == 0) {
                if (!(value instanceof JsonArray) && !(value instanceof JsonObject)) {
                    throw new JsonGenerationException("This method is not called within a valid context.");
                }
            } else {
                throw new JsonGenerationException("This method is not called within an array context.");
            }
        }
        try {
            this.writeComma();
            return this.writeValue(value);
        }
        catch (IOException ex) {
            throw new JsonGenerationException(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public JsonGenerator write(byte[] value) {
        if (this.m_state != 1) {
            throw new JsonGenerationException("This method is not called within an object context.");
        }
        try {
            this.writeComma();
            if (this.m_binaryFormat == 0) {
                this.base64Encode(value);
            } else {
                this.hexEncode(value);
            }
            return this;
        }
        catch (IOException ex) {
            throw new JsonGenerationException(ex.getMessage(), (Throwable)ex);
        }
    }

    public JsonGenerator write(String value) {
        if (this.m_state != 1) {
            throw new JsonGenerationException("This method is not called within an array context.");
        }
        try {
            this.writeComma();
            this.quote(value);
        }
        catch (IOException ex) {
            throw new JsonGenerationException(ex.getMessage(), (Throwable)ex);
        }
        return this;
    }

    public JsonGenerator write(BigDecimal value) {
        if (this.m_state != 1) {
            throw new JsonGenerationException("This method is not called within an array context.");
        }
        try {
            this.writeComma();
            this.w(value.toString());
        }
        catch (IOException ex) {
            throw new JsonGenerationException(ex.getMessage(), (Throwable)ex);
        }
        return this;
    }

    public JsonGenerator write(BigInteger value) {
        if (this.m_state != 1) {
            throw new JsonGenerationException("This method is not called within an array context.");
        }
        try {
            this.writeComma();
            this.w(value.toString());
        }
        catch (IOException ex) {
            throw new JsonGenerationException(ex.getMessage(), (Throwable)ex);
        }
        return this;
    }

    public JsonGenerator write(int value) {
        if (this.m_state != 1) {
            throw new JsonGenerationException("This method is not called within an array context.");
        }
        try {
            this.writeComma();
            this.wi(value);
        }
        catch (IOException ex) {
            throw new JsonGenerationException(ex.getMessage(), (Throwable)ex);
        }
        return this;
    }

    public JsonGenerator write(long value) {
        if (this.m_state != 1) {
            throw new JsonGenerationException("This method is not called within an array context.");
        }
        try {
            this.writeComma();
            this.w(Long.toString(value));
        }
        catch (IOException ex) {
            throw new JsonGenerationException(ex.getMessage(), (Throwable)ex);
        }
        return this;
    }

    public JsonGenerator write(double value) {
        if (this.m_state != 1) {
            throw new JsonGenerationException("This method is not called within an array context.");
        }
        try {
            this.writeComma();
            this.w(DoubleUtils.toString(value));
        }
        catch (IOException ex) {
            throw new JsonGenerationException(ex.getMessage(), (Throwable)ex);
        }
        return this;
    }

    public JsonGenerator write(boolean value) {
        if (this.m_state != 1) {
            throw new JsonGenerationException("This method is not called within an array context.");
        }
        try {
            this.writeComma();
            this.w(value ? "true" : "false");
        }
        catch (IOException ex) {
            throw new JsonGenerationException(ex.getMessage(), (Throwable)ex);
        }
        return this;
    }

    public JsonGenerator writeNull() {
        if (this.m_state != 1) {
            throw new JsonGenerationException("This method is not called within an array context.");
        }
        try {
            this.writeComma();
            this.w("null");
        }
        catch (IOException ex) {
            throw new JsonGenerationException(ex.getMessage(), (Throwable)ex);
        }
        return this;
    }

    public void close() {
        try {
            this.flush();
            this.m_out.close();
        }
        catch (IOException ex) {
            throw new JsonGenerationException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void flush() {
        try {
            if (this.m_pos > 0) {
                this.m_out.write(this.m_buffer, 0, this.m_pos);
                this.m_pos = 0;
            }
            this.m_out.flush();
        }
        catch (IOException ex) {
            throw new JsonGenerationException(ex.getMessage(), (Throwable)ex);
        }
    }

    void pushState(boolean isArray) {
        this.m_state = isArray ? 1 : 2;
        this.m_states.add(isArray);
    }

    boolean popState() {
        ArrayList<Boolean> states = this.m_states;
        int index = states.size() - 1;
        boolean isArray = states.remove(index);
        this.m_state = index == 0 ? -1 : (states.get(index - 1) != false ? 1 : 2);
        return isArray;
    }

    public boolean isKeyNameEscaped() {
        return this.m_keyNameEscaped;
    }

    public void setKeyNameEscaped(boolean b) {
        this.m_keyNameEscaped = b;
    }

    public int getBinaryFormat() {
        return this.m_binaryFormat;
    }

    public void setBinaryFormat(int binaryFormat) {
        this.m_binaryFormat = binaryFormat;
    }
}

