/*
 * Decompiled with CFR 0.152.
 */
package org.yuanheng.cookjson;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonLocation;
import javax.json.stream.JsonParsingException;
import org.yuanheng.cookjson.BOM;
import org.yuanheng.cookjson.CommentJsonParser;
import org.yuanheng.cookjson.ConfigHandler;
import org.yuanheng.cookjson.CookJsonParser;
import org.yuanheng.cookjson.JsonLocationImpl;
import org.yuanheng.cookjson.PrettyTextJsonGenerator;
import org.yuanheng.cookjson.TextJsonGenerator;
import org.yuanheng.cookjson.TextJsonParser;
import org.yuanheng.cookjson.UTF8TextJsonParser;

class TextJsonConfigHandler
implements ConfigHandler {
    private static final ConfigHandler s_instance = new TextJsonConfigHandler();

    public static CookJsonParser getJsonParser(InputStream is) {
        Charset charset;
        PushbackInputStream pis = new PushbackInputStream(is, 3);
        try {
            charset = BOM.guessCharset(pis);
        }
        catch (IOException ex) {
            JsonLocationImpl location = new JsonLocationImpl();
            location.m_streamOffset = 0L;
            throw new JsonParsingException(ex.getMessage(), (Throwable)ex, (JsonLocation)location);
        }
        if (charset == BOM.utf8) {
            return new UTF8TextJsonParser(pis);
        }
        return new TextJsonParser(new InputStreamReader((InputStream)pis, charset));
    }

    public static CookJsonParser getJsonParser(InputStream is, Charset charset) {
        if (BOM.utf8.equals(charset)) {
            return new UTF8TextJsonParser(is);
        }
        return new TextJsonParser(new InputStreamReader(is, charset));
    }

    public static ConfigHandler getInstance() {
        return s_instance;
    }

    private TextJsonConfigHandler() {
    }

    private void configure(Map<String, ?> config, CookJsonParser p) {
        boolean allowComments = false;
        Object obj = config.get("comment");
        if (obj != null) {
            allowComments = "true".equals(obj.toString());
        }
        ((CommentJsonParser)((Object)p)).setAllowComments(allowComments);
    }

    @Override
    public CookJsonParser createParser(Map<String, ?> config, Reader reader) {
        TextJsonParser p = new TextJsonParser(reader);
        this.configure(config, p);
        return p;
    }

    @Override
    public CookJsonParser createParser(Map<String, ?> config, InputStream is) {
        CookJsonParser p = TextJsonConfigHandler.getJsonParser(is);
        this.configure(config, p);
        return p;
    }

    @Override
    public CookJsonParser createParser(Map<String, ?> config, InputStream is, Charset charset) {
        CookJsonParser p = TextJsonConfigHandler.getJsonParser(is, charset);
        this.configure(config, p);
        return p;
    }

    @Override
    public JsonGenerator createGenerator(Map<String, ?> config, Writer writer) {
        boolean pretty = false;
        Object obj = config.get("javax.json.stream.JsonGenerator.prettyPrinting");
        if (obj != null) {
            pretty = "true".equals(obj.toString());
        }
        TextJsonGenerator g = pretty ? new PrettyTextJsonGenerator(writer) : new TextJsonGenerator(writer);
        int binaryFormat = 0;
        obj = config.get("binaryFormat");
        if (obj != null && "hex".equals(obj.toString())) {
            binaryFormat = 1;
        }
        g.setBinaryFormat(binaryFormat);
        return g;
    }

    @Override
    public JsonGenerator createGenerator(Map<String, ?> config, OutputStream os) {
        return this.createGenerator(config, new OutputStreamWriter(os, BOM.utf8));
    }

    @Override
    public JsonGenerator createGenerator(Map<String, ?> config, OutputStream os, Charset charset) {
        return this.createGenerator(config, new OutputStreamWriter(os, charset));
    }
}

