/*
 * Decompiled with CFR 0.152.
 */
package org.yuanheng.cookjson;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class Quote {
    static final char[] hex = "0123456789abcdef".toCharArray();

    public static void quote(Writer out, String str) throws IOException {
        int i;
        int strLength = str.length();
        char[] esc = null;
        int start = 0;
        out.write(34);
        block7: for (i = 0; i < strLength; ++i) {
            int len;
            char ch = str.charAt(i);
            if (ch > '\\') continue;
            if (ch > '\"') {
                if (ch < '\\') continue;
                len = i - start + 1;
                out.write(str, start, len);
                start = i;
                continue;
            }
            if (ch >= ' ') {
                if (ch < '\"') continue;
                len = i - start;
                if (len > 0) {
                    out.write(str, start, len);
                }
                out.write(92);
                start = i;
                continue;
            }
            len = i - start;
            if (len > 0) {
                out.write(str, start, len);
            }
            start = i + 1;
            if (esc == null) {
                esc = new char[6];
                esc[0] = 92;
                esc[2] = 48;
                esc[3] = 48;
            }
            switch (ch) {
                case '\b': {
                    esc[1] = 98;
                    out.write(esc, 0, 2);
                    continue block7;
                }
                case '\t': {
                    esc[1] = 116;
                    out.write(esc, 0, 2);
                    continue block7;
                }
                case '\n': {
                    esc[1] = 110;
                    out.write(esc, 0, 2);
                    continue block7;
                }
                case '\r': {
                    esc[1] = 114;
                    out.write(esc, 0, 2);
                    continue block7;
                }
                case '\f': {
                    esc[1] = 102;
                    out.write(esc, 0, 2);
                    continue block7;
                }
                default: {
                    esc[1] = 117;
                    esc[4] = hex[ch >> 4 & 0xF];
                    esc[5] = hex[ch & 0xF];
                    out.write(esc, 0, 6);
                }
            }
        }
        int len = i - start;
        if (len > 0) {
            out.write(str, start, len);
        }
        out.write(34);
    }

    public static String quote(String str) {
        try {
            StringWriter sw = new StringWriter(str.length() + 10);
            Quote.quote(sw, str);
            sw.close();
            return sw.toString();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

