/*
 * Decompiled with CFR 0.152.
 */
package org.yuanheng.cookjson;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import org.yuanheng.cookjson.TextJsonGenerator;
import org.yuanheng.cookjson.value.CookJsonBinary;

public class PrettyTextJsonGenerator
extends TextJsonGenerator {
    private String m_indent = "\t";

    public PrettyTextJsonGenerator(OutputStream os) {
        super(os);
    }

    public PrettyTextJsonGenerator(Writer out) {
        super(out);
    }

    public void setIndentation(String indent) {
        this.m_indent = indent;
    }

    @Override
    void writeName(String name) throws IOException {
        if (this.m_first) {
            this.m_first = false;
        } else {
            this.w(',');
        }
        this.w('\n');
        int indents = this.m_states.size();
        String indent = this.m_indent;
        for (int i = 0; i < indents; ++i) {
            this.w(indent);
        }
        if (this.m_keyNameEscaped) {
            this.w(name);
        } else {
            this.quote(name);
        }
        this.w(" : ");
    }

    @Override
    void writeComma() throws IOException {
        if (this.m_first) {
            this.m_first = false;
            int indents = this.m_states.size();
            if (indents == 0) {
                return;
            }
            this.w('\n');
            String indent = this.m_indent;
            for (int i = 0; i < indents; ++i) {
                this.w(indent);
            }
        } else {
            this.w(',');
            this.w('\n');
            int indents = this.m_states.size();
            String indent = this.m_indent;
            for (int i = 0; i < indents; ++i) {
                this.w(indent);
            }
        }
    }

    @Override
    public JsonGenerator writeEnd() {
        if (!this.m_first) {
            try {
                this.w('\n');
                int indents = this.m_states.size();
                String indent = this.m_indent;
                for (int i = 1; i < indents; ++i) {
                    this.w(indent);
                }
            }
            catch (IOException ex) {
                throw new JsonException(ex.getMessage(), (Throwable)ex);
            }
        }
        return super.writeEnd();
    }

    @Override
    JsonGenerator writeValue(JsonValue value) throws IOException {
        switch (value.getValueType()) {
            case ARRAY: {
                JsonArray array = (JsonArray)value;
                this.w('[');
                this.pushState(true);
                this.m_first = true;
                for (JsonValue v : array) {
                    this.writeComma();
                    this.writeValue(v);
                }
                if (!this.m_first) {
                    this.w('\n');
                    int indents = this.m_states.size();
                    String indent = this.m_indent;
                    for (int i = 1; i < indents; ++i) {
                        this.w(indent);
                    }
                }
                this.w(']');
                this.popState();
                this.m_first = false;
                break;
            }
            case OBJECT: {
                JsonObject obj = (JsonObject)value;
                this.w('{');
                this.pushState(false);
                this.m_first = true;
                for (Map.Entry entry : obj.entrySet()) {
                    JsonValue v = (JsonValue)entry.getValue();
                    this.writeName((String)entry.getKey());
                    this.writeValue(v);
                }
                if (!this.m_first) {
                    this.w('\n');
                    int indents = this.m_states.size();
                    String indent = this.m_indent;
                    for (int i = 1; i < indents; ++i) {
                        this.w(indent);
                    }
                }
                this.w('}');
                this.popState();
                this.m_first = false;
                break;
            }
            case NULL: {
                this.w("null");
                break;
            }
            case NUMBER: {
                this.w(value.toString());
                break;
            }
            case STRING: {
                if (value instanceof CookJsonBinary) {
                    byte[] bytes = ((CookJsonBinary)value).getBytes();
                    if (this.m_binaryFormat == 0) {
                        this.base64Encode(bytes);
                        break;
                    }
                    this.hexEncode(bytes);
                    break;
                }
                this.quote(((JsonString)value).getString());
                break;
            }
            case TRUE: {
                this.w("true");
                break;
            }
            case FALSE: {
                this.w("false");
            }
        }
        return this;
    }
}

