/*
 * Decompiled with CFR 0.152.
 */
package org.yuanheng.cookjson;

import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import org.yuanheng.cookjson.ConfigHandler;
import org.yuanheng.cookjson.JsonWriterImpl;

class JsonWriterFactoryImpl
implements JsonWriterFactory {
    private final Map<String, ?> m_config;
    private final ConfigHandler m_handler;

    public JsonWriterFactoryImpl(Map<String, ?> config, ConfigHandler handler) {
        this.m_config = config;
        this.m_handler = handler;
    }

    public JsonWriter createWriter(Writer writer) {
        return new JsonWriterImpl(this.m_handler.createGenerator(this.m_config, writer));
    }

    public JsonWriter createWriter(OutputStream os) {
        return new JsonWriterImpl(this.m_handler.createGenerator(this.m_config, os));
    }

    public JsonWriter createWriter(OutputStream os, Charset charset) {
        return new JsonWriterImpl(this.m_handler.createGenerator(this.m_config, os, charset));
    }

    public Map<String, ?> getConfigInUse() {
        return Collections.unmodifiableMap(this.m_config);
    }
}

