/*
 * Decompiled with CFR 0.152.
 */
package org.yuanheng.cookjson;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonLocation;
import javax.json.stream.JsonParser;
import org.yuanheng.cookjson.CookJsonParser;
import org.yuanheng.cookjson.JsonLocationImpl;
import org.yuanheng.cookjson.value.CookJsonBinary;

public class JsonStructureParser
implements CookJsonParser {
    private JsonStructure m_s;
    private ArrayList<Object> m_queue = new ArrayList();
    private JsonParser.Event m_event;
    private String m_name;
    private JsonValue m_value;

    public JsonStructureParser(JsonStructure s) {
        this.m_s = s;
        this.push(s);
    }

    private Object top() {
        return this.m_queue.get(this.m_queue.size() - 1);
    }

    private void pop() {
        this.m_queue.remove(this.m_queue.size() - 1);
    }

    private void push(JsonStructure value) {
        if (value instanceof JsonArray) {
            ArrayQueue q = new ArrayQueue();
            q.array = (JsonArray)value;
            q.index = 0;
            this.m_queue.add(q);
        } else if (value instanceof JsonObject) {
            JsonObject o = (JsonObject)value;
            LinkedList names = new LinkedList();
            names.addAll(o.keySet());
            ObjectQueue q = new ObjectQueue();
            q.obj = o;
            q.names = names;
            this.m_queue.add(q);
        }
    }

    public boolean hasNext() {
        return this.m_queue != null && !this.m_queue.isEmpty();
    }

    public JsonParser.Event next() {
        if (this.m_queue == null || this.m_queue.size() == 0) {
            throw new NoSuchElementException();
        }
        JsonParser.Event e = this.m_event;
        if (e == null) {
            this.m_value = this.m_s;
            this.m_event = this.getEvent((JsonValue)this.m_s);
            return this.m_event;
        }
        if (e == JsonParser.Event.KEY_NAME) {
            ObjectQueue q = (ObjectQueue)this.top();
            JsonValue v = (JsonValue)q.obj.get((Object)this.m_name);
            this.m_name = null;
            this.m_value = v;
            if (v instanceof JsonStructure) {
                this.push((JsonStructure)v);
            }
            this.m_event = this.getEvent(v);
        } else {
            Object o = this.top();
            if (o instanceof ObjectQueue) {
                ObjectQueue q = (ObjectQueue)o;
                if (q.names.isEmpty()) {
                    this.m_value = null;
                    this.pop();
                    this.m_event = JsonParser.Event.END_OBJECT;
                } else {
                    this.m_name = q.names.removeFirst();
                    this.m_event = JsonParser.Event.KEY_NAME;
                }
            } else {
                ArrayQueue q = (ArrayQueue)o;
                JsonArray a = q.array;
                if (q.index < a.size()) {
                    JsonValue v = (JsonValue)a.get(q.index++);
                    this.m_name = null;
                    this.m_value = v;
                    if (v instanceof JsonStructure) {
                        this.push((JsonStructure)v);
                    }
                    this.m_event = this.getEvent(v);
                } else {
                    this.m_value = null;
                    this.pop();
                    this.m_event = JsonParser.Event.END_ARRAY;
                }
            }
        }
        return this.m_event;
    }

    private JsonParser.Event getEvent(JsonValue v) {
        switch (v.getValueType()) {
            case ARRAY: {
                return JsonParser.Event.START_ARRAY;
            }
            case FALSE: {
                return JsonParser.Event.VALUE_FALSE;
            }
            case NULL: {
                return JsonParser.Event.VALUE_NULL;
            }
            case NUMBER: {
                return JsonParser.Event.VALUE_NUMBER;
            }
            case OBJECT: {
                return JsonParser.Event.START_OBJECT;
            }
            case STRING: {
                return JsonParser.Event.VALUE_STRING;
            }
            case TRUE: {
                return JsonParser.Event.VALUE_TRUE;
            }
        }
        throw new IllegalStateException();
    }

    public String getString() {
        switch (this.m_event) {
            case VALUE_STRING: {
                return ((JsonString)this.m_value).getString();
            }
            case KEY_NAME: {
                return this.m_name;
            }
            case VALUE_NUMBER: {
                return ((JsonNumber)this.m_value).toString();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isBinary() {
        if (this.m_event != JsonParser.Event.VALUE_STRING) {
            throw new IllegalStateException();
        }
        return this.m_value instanceof CookJsonBinary;
    }

    @Override
    public byte[] getBytes() {
        if (this.m_event != JsonParser.Event.VALUE_STRING) {
            throw new IllegalStateException();
        }
        if (this.m_value instanceof CookJsonBinary) {
            return ((CookJsonBinary)this.m_value).getBytes();
        }
        throw new IllegalStateException();
    }

    public boolean isIntegralNumber() {
        if (this.m_event != JsonParser.Event.VALUE_NUMBER) {
            throw new IllegalStateException();
        }
        return ((JsonNumber)this.m_value).isIntegral();
    }

    public int getInt() {
        if (this.m_event != JsonParser.Event.VALUE_NUMBER) {
            throw new IllegalStateException();
        }
        return ((JsonNumber)this.m_value).intValue();
    }

    public long getLong() {
        if (this.m_event != JsonParser.Event.VALUE_NUMBER) {
            throw new IllegalStateException();
        }
        return ((JsonNumber)this.m_value).longValue();
    }

    public BigDecimal getBigDecimal() {
        if (this.m_event != JsonParser.Event.VALUE_NUMBER) {
            throw new IllegalStateException();
        }
        return ((JsonNumber)this.m_value).bigDecimalValue();
    }

    public JsonLocation getLocation() {
        return JsonLocationImpl.Unknown;
    }

    public void close() {
        this.m_s = null;
        this.m_queue = null;
    }

    @Override
    public JsonParser.Event getEvent() {
        return this.m_event;
    }

    @Override
    public JsonValue getValue() {
        return this.m_value;
    }

    private static class ObjectQueue {
        JsonObject obj;
        LinkedList<String> names;

        private ObjectQueue() {
        }
    }

    private static class ArrayQueue {
        JsonArray array;
        int index;

        private ArrayQueue() {
        }
    }
}

