/*
 * Decompiled with CFR 0.152.
 */
package org.yuanheng.cookjson;

import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.stream.JsonParser;
import org.yuanheng.cookjson.CookJsonParser;
import org.yuanheng.cookjson.Utils;

class JsonReaderImpl
implements JsonReader {
    private final CookJsonParser m_p;
    private boolean m_read;

    public JsonReaderImpl(CookJsonParser p) {
        this.m_p = p;
    }

    public JsonStructure read() {
        if (this.m_read) {
            throw new IllegalStateException();
        }
        this.m_read = true;
        if (!this.m_p.hasNext()) {
            throw new IllegalStateException();
        }
        JsonParser.Event e = this.m_p.next();
        if (e != JsonParser.Event.START_ARRAY && e != JsonParser.Event.START_OBJECT) {
            throw new IllegalStateException();
        }
        return Utils.getStructure(this.m_p);
    }

    public JsonObject readObject() {
        if (this.m_read) {
            throw new IllegalStateException();
        }
        this.m_read = true;
        if (!this.m_p.hasNext()) {
            throw new IllegalStateException();
        }
        JsonParser.Event e = this.m_p.next();
        if (e != JsonParser.Event.START_OBJECT) {
            throw new IllegalStateException();
        }
        return (JsonObject)Utils.getStructure(this.m_p);
    }

    public JsonArray readArray() {
        if (this.m_read) {
            throw new IllegalStateException();
        }
        this.m_read = true;
        if (!this.m_p.hasNext()) {
            throw new IllegalStateException();
        }
        JsonParser.Event e = this.m_p.next();
        if (e != JsonParser.Event.START_ARRAY && e != JsonParser.Event.START_OBJECT) {
            throw new IllegalStateException();
        }
        return (JsonArray)Utils.getStructure(this.m_p);
    }

    public void close() {
        this.m_p.close();
    }
}

