/*
 * Decompiled with CFR 0.152.
 */
package org.yuanheng.cookjson;

import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import org.yuanheng.cookjson.ConfigHandler;
import org.yuanheng.cookjson.JsonReaderImpl;

class JsonReaderFactoryImpl
implements JsonReaderFactory {
    private final Map<String, ?> m_config;
    private final ConfigHandler m_handler;

    public JsonReaderFactoryImpl(Map<String, ?> config, ConfigHandler handler) {
        this.m_config = config;
        this.m_handler = handler;
    }

    public JsonReader createReader(Reader reader) {
        return new JsonReaderImpl(this.m_handler.createParser(this.m_config, reader));
    }

    public JsonReader createReader(InputStream is) {
        return new JsonReaderImpl(this.m_handler.createParser(this.m_config, is));
    }

    public JsonReader createReader(InputStream is, Charset charset) {
        return new JsonReaderImpl(this.m_handler.createParser(this.m_config, is, charset));
    }

    public Map<String, ?> getConfigInUse() {
        return Collections.unmodifiableMap(this.m_config);
    }
}

