/*
 * Decompiled with CFR 0.152.
 */
package org.yuanheng.cookjson;

import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParserFactory;
import org.yuanheng.cookjson.ConfigHandler;
import org.yuanheng.cookjson.JsonStructureParser;

class JsonParserFactoryImpl
implements JsonParserFactory {
    private final Map<String, ?> m_config;
    private final ConfigHandler m_handler;

    public JsonParserFactoryImpl(Map<String, ?> config, ConfigHandler handler) {
        this.m_config = config;
        this.m_handler = handler;
    }

    public JsonParser createParser(Reader reader) {
        return this.m_handler.createParser(this.m_config, reader);
    }

    public JsonParser createParser(InputStream is) {
        return this.m_handler.createParser(this.m_config, is);
    }

    public JsonParser createParser(InputStream is, Charset charset) {
        return this.m_handler.createParser(this.m_config, is, charset);
    }

    public JsonParser createParser(JsonObject obj) {
        return new JsonStructureParser((JsonStructure)obj);
    }

    public JsonParser createParser(JsonArray array) {
        return new JsonStructureParser((JsonStructure)array);
    }

    public Map<String, ?> getConfigInUse() {
        return Collections.unmodifiableMap(this.m_config);
    }
}

