/*
 * Decompiled with CFR 0.152.
 */
package org.yuanheng.cookjson;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.yuanheng.cookjson.value.CookJsonBigDecimal;
import org.yuanheng.cookjson.value.CookJsonDouble;
import org.yuanheng.cookjson.value.CookJsonInt;
import org.yuanheng.cookjson.value.CookJsonLong;
import org.yuanheng.cookjson.value.CookJsonObject;
import org.yuanheng.cookjson.value.CookJsonString;

class JsonObjectBuilderImpl
implements JsonObjectBuilder {
    private final CookJsonObject m_object = new CookJsonObject();

    JsonObjectBuilderImpl() {
    }

    public JsonObjectBuilder add(String name, JsonValue value) {
        this.m_object.put(name, value);
        return this;
    }

    public JsonObjectBuilder add(String name, String value) {
        this.m_object.put(name, new CookJsonString(value));
        return this;
    }

    public JsonObjectBuilder add(String name, BigInteger value) {
        this.m_object.put(name, new CookJsonBigDecimal(value));
        return this;
    }

    public JsonObjectBuilder add(String name, BigDecimal value) {
        this.m_object.put(name, new CookJsonBigDecimal(value));
        return this;
    }

    public JsonObjectBuilder add(String name, int value) {
        this.m_object.put(name, new CookJsonInt(value));
        return this;
    }

    public JsonObjectBuilder add(String name, long value) {
        this.m_object.put(name, new CookJsonLong(value));
        return this;
    }

    public JsonObjectBuilder add(String name, double value) {
        this.m_object.put(name, new CookJsonDouble(value));
        return this;
    }

    public JsonObjectBuilder add(String name, boolean value) {
        this.m_object.put(name, value ? JsonValue.TRUE : JsonValue.FALSE);
        return this;
    }

    public JsonObjectBuilder addNull(String name) {
        this.m_object.put(name, JsonValue.NULL);
        return this;
    }

    public JsonObjectBuilder add(String name, JsonObjectBuilder builder) {
        this.m_object.put(name, builder.build());
        return this;
    }

    public JsonObjectBuilder add(String name, JsonArrayBuilder builder) {
        this.m_object.put(name, builder.build());
        return this;
    }

    public JsonObject build() {
        return this.m_object;
    }
}

