/*
 * Decompiled with CFR 0.152.
 */
package org.yuanheng.cookjson;

import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import org.yuanheng.cookjson.ConfigHandler;

class JsonGeneratorFactoryImpl
implements JsonGeneratorFactory {
    private final Map<String, ?> m_config;
    private final ConfigHandler m_handler;

    public JsonGeneratorFactoryImpl(Map<String, ?> config, ConfigHandler handler) {
        this.m_config = config;
        this.m_handler = handler;
    }

    public JsonGenerator createGenerator(Writer writer) {
        return this.m_handler.createGenerator(this.m_config, writer);
    }

    public JsonGenerator createGenerator(OutputStream os) {
        return this.m_handler.createGenerator(this.m_config, os);
    }

    public JsonGenerator createGenerator(OutputStream os, Charset charset) {
        return this.m_handler.createGenerator(this.m_config, os, charset);
    }

    public Map<String, ?> getConfigInUse() {
        return Collections.unmodifiableMap(this.m_config);
    }
}

