/*
 * Decompiled with CFR 0.152.
 */
package org.yuanheng.cookjson;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.yuanheng.cookjson.value.CookJsonArray;
import org.yuanheng.cookjson.value.CookJsonBigDecimal;
import org.yuanheng.cookjson.value.CookJsonDouble;
import org.yuanheng.cookjson.value.CookJsonInt;
import org.yuanheng.cookjson.value.CookJsonLong;
import org.yuanheng.cookjson.value.CookJsonString;

class JsonArrayBuilderImpl
implements JsonArrayBuilder {
    private final CookJsonArray m_array = new CookJsonArray();

    JsonArrayBuilderImpl() {
    }

    public JsonArrayBuilder add(JsonValue value) {
        this.m_array.add(value);
        return this;
    }

    public JsonArrayBuilder add(String value) {
        this.m_array.add(new CookJsonString(value));
        return this;
    }

    public JsonArrayBuilder add(BigDecimal value) {
        this.m_array.add(new CookJsonBigDecimal(value));
        return this;
    }

    public JsonArrayBuilder add(BigInteger value) {
        this.m_array.add(new CookJsonBigDecimal(value));
        return this;
    }

    public JsonArrayBuilder add(int value) {
        this.m_array.add(new CookJsonInt(value));
        return this;
    }

    public JsonArrayBuilder add(long value) {
        this.m_array.add(new CookJsonLong(value));
        return this;
    }

    public JsonArrayBuilder add(double value) {
        this.m_array.add(new CookJsonDouble(value));
        return this;
    }

    public JsonArrayBuilder add(boolean value) {
        this.m_array.add(value ? JsonValue.TRUE : JsonValue.FALSE);
        return this;
    }

    public JsonArrayBuilder addNull() {
        this.m_array.add(JsonValue.NULL);
        return this;
    }

    public JsonArrayBuilder add(JsonObjectBuilder builder) {
        this.m_array.add(builder.build());
        return this;
    }

    public JsonArrayBuilder add(JsonArrayBuilder builder) {
        this.m_array.add(builder.build());
        return this;
    }

    public JsonArray build() {
        return this.m_array;
    }
}

