/*
 * Decompiled with CFR 0.152.
 */
package org.yuanheng.cookjson;

import java.math.BigInteger;

public class DoubleUtils {
    private static final int dblMantDig = 53;
    private static final BigInteger[] bp5a = new BigInteger[326];
    private static final long[] lp5 = new long[]{1L, 5L, 25L, 125L, 625L, 3125L, 15625L, 78125L, 390625L, 1953125L, 9765625L, 48828125L, 244140625L, 1220703125L, 6103515625L, 30517578125L, 152587890625L, 762939453125L, 3814697265625L, 19073486328125L, 95367431640625L, 476837158203125L, 2384185791015625L, 11920928955078125L, 59604644775390625L, 298023223876953125L, 1490116119384765625L, 7450580596923828125L};
    private static final double llog2 = Math.log10(2.0);

    private static final BigInteger bp5(int p) {
        BigInteger v;
        BigInteger[] pa = bp5a;
        if (pa[p] != null) {
            return pa[p];
        }
        if (p < lp5.length) {
            BigInteger v2;
            pa[p] = v2 = BigInteger.valueOf(lp5[p]);
            return v2;
        }
        int a = p >> 1;
        int b = p - a;
        pa[p] = v = DoubleUtils.bp5(a).multiply(DoubleUtils.bp5(b));
        return v;
    }

    private static long rq(BigInteger num, BigInteger den) {
        BigInteger[] quorem = num.divideAndRemainder(den);
        long quo = quorem[0].longValue();
        int cmpflg = quorem[1].shiftLeft(1).compareTo(den);
        if ((quo & 1L) == 0L ? 1 == cmpflg : -1 < cmpflg) {
            return quo + 1L;
        }
        return quo;
    }

    private static double metd(long lmant, int point) {
        BigInteger mant = BigInteger.valueOf(lmant);
        if (point >= 0) {
            BigInteger num = mant.multiply(DoubleUtils.bp5(point));
            int bex = num.bitLength() - 53;
            if (bex <= 0) {
                return Math.scalb(num.doubleValue(), point);
            }
            long quo = DoubleUtils.rq(num, BigInteger.ONE.shiftLeft(bex));
            return Math.scalb((double)quo, bex + point);
        }
        int maxpow = bp5a.length - 1;
        BigInteger scl = -point <= maxpow ? DoubleUtils.bp5(-point) : DoubleUtils.bp5(maxpow).multiply(DoubleUtils.bp5(-point - maxpow));
        int bex = mant.bitLength() - scl.bitLength() - 53;
        BigInteger num = mant.shiftLeft(-bex);
        long quo = DoubleUtils.rq(num, scl);
        if (64 - Long.numberOfLeadingZeros(quo) > 53) {
            ++bex;
            quo = DoubleUtils.rq(num, scl.shiftLeft(1));
        }
        return Math.scalb((double)quo, bex + point);
    }

    public static String toString(double f) {
        int len;
        long lquo;
        BigInteger num;
        int ue2;
        long lbits = Double.doubleToLongBits(f);
        if (f != f) {
            return "NaN";
        }
        if (f + f == f) {
            return f == 0.0 ? "0" : (f > 0.0 ? "Infinity" : "-Infinity");
        }
        StringBuilder str = new StringBuilder(24);
        if (f < 0.0) {
            str.append('-');
            f = -f;
        }
        int e2 = ue2 - 1023 - 52 + ((ue2 = (int)(lbits >>> 52 & 0x7FFL)) == 0 ? 1 : 0);
        int point = (int)Math.ceil((double)e2 * llog2);
        long lmant = (lbits & 0xFFFFFFFFFFFFFL) + (ue2 == 0 ? 0L : 0x10000000000000L);
        BigInteger mant = BigInteger.valueOf(lmant);
        if (e2 > 0) {
            num = mant.shiftLeft(e2 - point);
            lquo = DoubleUtils.rq(num, DoubleUtils.bp5(point));
            if (DoubleUtils.metd(lquo, point) != f) {
                lquo = DoubleUtils.rq(num.shiftLeft(1), DoubleUtils.bp5(--point));
            }
        } else {
            BigInteger den;
            num = mant.multiply(DoubleUtils.bp5(-point));
            lquo = DoubleUtils.rq(num, den = BigInteger.ONE.shiftLeft(point - e2));
            if (DoubleUtils.metd(lquo, point) != f) {
                --point;
                lquo = DoubleUtils.rq(num.multiply(BigInteger.TEN), den);
            }
        }
        String sman = Long.toString(lquo);
        int lent = len = sman.length();
        while (sman.charAt(lent - 1) == '0') {
            --lent;
        }
        int exp = point + len - 1;
        if (exp >= 0 && exp < len) {
            str.append(sman, 0, ++exp);
            if (lent > exp) {
                str.append('.');
                str.append(sman, exp, lent);
            }
        } else if (exp < 0 && exp > -5) {
            str.append("0.");
            str.append("0000".substring(0, -exp - 1));
            str.append(sman, 0, lent);
        } else {
            str.append(sman, 0, 1);
            if (lent > 1) {
                str.append('.');
                str.append(sman, 1, lent);
            }
            if (exp != 0) {
                str.append('e');
                str.append(exp);
            }
        }
        return str.toString();
    }
}

