/*
 * Decompiled with CFR 0.152.
 */
package org.yuanheng.cookjson;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import javax.json.spi.JsonProvider;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParserFactory;
import org.yuanheng.cookjson.BsonConfigHandler;
import org.yuanheng.cookjson.ConfigHandler;
import org.yuanheng.cookjson.JsonArrayBuilderImpl;
import org.yuanheng.cookjson.JsonBuilderFactoryImpl;
import org.yuanheng.cookjson.JsonGeneratorFactoryImpl;
import org.yuanheng.cookjson.JsonObjectBuilderImpl;
import org.yuanheng.cookjson.JsonParserFactoryImpl;
import org.yuanheng.cookjson.JsonReaderFactoryImpl;
import org.yuanheng.cookjson.JsonReaderImpl;
import org.yuanheng.cookjson.JsonWriterFactoryImpl;
import org.yuanheng.cookjson.JsonWriterImpl;
import org.yuanheng.cookjson.TextJsonConfigHandler;
import org.yuanheng.cookjson.TextJsonGenerator;
import org.yuanheng.cookjson.TextJsonParser;

public class CookJsonProvider
extends JsonProvider {
    public static final String FORMAT = "format";
    public static final String FORMAT_JSON = "json";
    public static final String FORMAT_BSON = "bson";
    public static final String COMMENT = "comment";
    public static final String BINARY_FORMAT = "binaryFormat";
    public static final String BINARY_FORMAT_BASE64 = "base64";
    public static final String BINARY_FORMAT_HEX = "hex";
    public static final String USE_DOUBLE = "useDouble";
    public static final String ROOT_AS_ARRAY = "rootAsArray";

    public JsonParser createParser(Reader reader) {
        return new TextJsonParser(reader);
    }

    public JsonParser createParser(InputStream is) {
        return TextJsonConfigHandler.getJsonParser(is);
    }

    public JsonParserFactory createParserFactory(Map<String, ?> config) {
        return new JsonParserFactoryImpl(config, this.getHandler(config));
    }

    public JsonGenerator createGenerator(Writer writer) {
        return new TextJsonGenerator(writer);
    }

    public JsonGenerator createGenerator(OutputStream os) {
        return new TextJsonGenerator(os);
    }

    public JsonGeneratorFactory createGeneratorFactory(Map<String, ?> config) {
        return new JsonGeneratorFactoryImpl(config, this.getHandler(config));
    }

    public JsonReader createReader(Reader reader) {
        return new JsonReaderImpl(new TextJsonParser(reader));
    }

    public JsonReader createReader(InputStream is) {
        return new JsonReaderImpl(TextJsonConfigHandler.getJsonParser(is));
    }

    public JsonWriter createWriter(Writer writer) {
        return new JsonWriterImpl(new TextJsonGenerator(writer));
    }

    public JsonWriter createWriter(OutputStream os) {
        return new JsonWriterImpl(new TextJsonGenerator(os));
    }

    public JsonWriterFactory createWriterFactory(Map<String, ?> config) {
        return new JsonWriterFactoryImpl(config, this.getHandler(config));
    }

    public JsonReaderFactory createReaderFactory(Map<String, ?> config) {
        return new JsonReaderFactoryImpl(config, this.getHandler(config));
    }

    public JsonObjectBuilder createObjectBuilder() {
        return new JsonObjectBuilderImpl();
    }

    public JsonArrayBuilder createArrayBuilder() {
        return new JsonArrayBuilderImpl();
    }

    public JsonBuilderFactory createBuilderFactory(Map<String, ?> config) {
        return new JsonBuilderFactoryImpl(config);
    }

    private ConfigHandler getHandler(Map<String, ?> config) {
        boolean bson = FORMAT_BSON.equals(config.get(FORMAT));
        if (bson) {
            return BsonConfigHandler.getInstance();
        }
        return TextJsonConfigHandler.getInstance();
    }
}

