/*
 * Decompiled with CFR 0.152.
 */
package org.yuanheng.cookjson;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import javax.json.JsonValue;
import javax.json.stream.JsonLocation;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParsingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.yuanheng.cookjson.BsonInputStream;
import org.yuanheng.cookjson.CookJsonParser;
import org.yuanheng.cookjson.DoubleUtils;
import org.yuanheng.cookjson.JsonLocationImpl;
import org.yuanheng.cookjson.Utils;
import org.yuanheng.cookjson.value.CookJsonBinary;
import org.yuanheng.cookjson.value.CookJsonDouble;
import org.yuanheng.cookjson.value.CookJsonInt;
import org.yuanheng.cookjson.value.CookJsonLong;
import org.yuanheng.cookjson.value.CookJsonString;

public class BsonParser
implements CookJsonParser {
    private final BsonInputStream m_is;
    private int m_fieldType;
    private String m_fieldName;
    private JsonParser.Event m_event;
    private Object m_value;
    private ArrayList<Boolean> m_states = new ArrayList();
    private int m_state = 0;
    private JsonLocationImpl m_location = new JsonLocationImpl();
    private boolean m_inArray;
    private boolean m_rootAsArray;
    private int m_binaryFormat;

    public BsonParser(InputStream is) {
        this.m_is = new BsonInputStream(is);
        this.m_location.m_columnNumber = -1L;
        this.m_location.m_lineNumber = -1L;
    }

    public boolean hasNext() {
        return this.m_state != -1;
    }

    @Override
    public JsonParser.Event getEvent() {
        return this.m_event;
    }

    @Override
    public JsonValue getValue() {
        if (this.m_event == null) {
            throw new IllegalStateException();
        }
        switch (this.m_event) {
            case START_ARRAY: 
            case START_OBJECT: {
                return Utils.getStructure(this);
            }
            case VALUE_STRING: {
                if (this.m_value instanceof byte[]) {
                    CookJsonBinary v = new CookJsonBinary((byte[])this.m_value);
                    v.setBinaryFormat(this.m_binaryFormat);
                    return v;
                }
                return new CookJsonString((String)this.m_value);
            }
            case VALUE_NUMBER: {
                if (this.m_value instanceof Integer) {
                    return new CookJsonInt((Integer)this.m_value);
                }
                if (this.m_value instanceof Long) {
                    return new CookJsonLong((Long)this.m_value);
                }
                return new CookJsonDouble((Double)this.m_value);
            }
            case VALUE_NULL: {
                return JsonValue.NULL;
            }
            case VALUE_TRUE: {
                return JsonValue.TRUE;
            }
            case VALUE_FALSE: {
                return JsonValue.FALSE;
            }
        }
        throw new IllegalStateException();
    }

    private void getField() throws IOException {
        this.m_location.m_streamOffset = this.m_is.getLocation();
        this.m_fieldType = this.m_is.read() & 0xFF;
        this.m_fieldName = this.m_fieldType == 0 ? null : this.m_is.readCString();
    }

    private JsonParser.Event getEventFromType(int type) throws IOException {
        switch (type) {
            case 0: {
                Boolean b = this.m_states.remove(this.m_states.size() - 1);
                this.m_value = null;
                if (this.m_states.isEmpty()) {
                    this.m_state = -1;
                } else {
                    this.m_inArray = this.m_states.get(this.m_states.size() - 1);
                    int n = this.m_state = this.m_inArray ? 1 : 3;
                }
                if (b.booleanValue()) {
                    return JsonParser.Event.END_ARRAY;
                }
                return JsonParser.Event.END_OBJECT;
            }
            case 4: {
                this.m_states.add(Boolean.TRUE);
                this.m_inArray = true;
                this.m_state = 1;
                this.m_value = null;
                this.m_is.readInt();
                return JsonParser.Event.START_ARRAY;
            }
            case 3: {
                this.m_states.add(Boolean.FALSE);
                this.m_inArray = false;
                this.m_state = 3;
                this.m_value = null;
                this.m_is.readInt();
                return JsonParser.Event.START_OBJECT;
            }
            case 10: {
                this.m_state = this.m_inArray ? 1 : 3;
                this.m_value = null;
                return JsonParser.Event.VALUE_NULL;
            }
            case 1: {
                this.m_state = this.m_inArray ? 1 : 3;
                this.m_value = this.m_is.readDouble();
                return JsonParser.Event.VALUE_NUMBER;
            }
            case 16: {
                this.m_state = this.m_inArray ? 1 : 3;
                this.m_value = this.m_is.readInt();
                return JsonParser.Event.VALUE_NUMBER;
            }
            case 9: 
            case 17: 
            case 18: {
                this.m_state = this.m_inArray ? 1 : 3;
                this.m_value = this.m_is.readLong();
                return JsonParser.Event.VALUE_NUMBER;
            }
            case 2: 
            case 13: 
            case 14: {
                this.m_state = this.m_inArray ? 1 : 3;
                this.m_value = this.m_is.getStringValue();
                return JsonParser.Event.VALUE_STRING;
            }
            case 8: {
                this.m_state = this.m_inArray ? 1 : 3;
                this.m_value = this.m_is.readBoolean();
                return (Boolean)this.m_value != false ? JsonParser.Event.VALUE_TRUE : JsonParser.Event.VALUE_FALSE;
            }
            case 7: {
                this.m_state = this.m_inArray ? 1 : 3;
                this.m_value = this.m_is.getObjectId();
                return JsonParser.Event.VALUE_STRING;
            }
            case 5: {
                this.m_state = this.m_inArray ? 1 : 3;
                this.m_value = this.m_is.getBinary();
                return JsonParser.Event.VALUE_STRING;
            }
        }
        throw new JsonParsingException("Unknown field: " + type, this.getLocation());
    }

    public JsonParser.Event next() {
        try {
            switch (this.m_state) {
                case -1: {
                    throw new NoSuchElementException();
                }
                case 0: {
                    this.m_state = this.m_rootAsArray ? 1 : 3;
                    this.m_fieldType = this.m_rootAsArray ? 4 : 3;
                    this.m_fieldName = null;
                    this.m_event = this.getEventFromType(this.m_fieldType);
                    break;
                }
                case 5: {
                    this.m_event = this.getEventFromType(this.m_fieldType);
                    break;
                }
                case 1: {
                    this.getField();
                    this.m_event = this.getEventFromType(this.m_fieldType);
                    break;
                }
                case 3: {
                    this.getField();
                    if (this.m_fieldType == 0) {
                        Boolean b = this.m_states.remove(this.m_states.size() - 1);
                        if (b.booleanValue()) {
                            throw new IllegalStateException();
                        }
                        this.m_value = null;
                        if (this.m_states.isEmpty()) {
                            this.m_state = -1;
                        } else {
                            this.m_inArray = this.m_states.get(this.m_states.size() - 1);
                            this.m_state = this.m_inArray ? 1 : 3;
                        }
                        return JsonParser.Event.END_OBJECT;
                    }
                    this.m_event = JsonParser.Event.KEY_NAME;
                    this.m_value = this.m_fieldName;
                    this.m_state = 5;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return this.m_event;
        }
        catch (IOException ex) {
            throw new JsonParsingException(ex.getMessage(), (Throwable)ex, (JsonLocation)this.m_location);
        }
    }

    public String getString() {
        switch (this.m_event) {
            case KEY_NAME: {
                return (String)this.m_value;
            }
            case VALUE_STRING: {
                if (this.m_value instanceof byte[]) {
                    if (this.m_binaryFormat == 1) {
                        return Hex.encodeHexString((byte[])((byte[])this.m_value));
                    }
                    return Base64.encodeBase64String((byte[])((byte[])this.m_value));
                }
                return (String)this.m_value;
            }
            case VALUE_NUMBER: {
                if (this.m_value instanceof Double) {
                    return DoubleUtils.toString((Double)this.m_value);
                }
                return this.m_value.toString();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isBinary() {
        if (this.m_event != JsonParser.Event.VALUE_STRING) {
            throw new IllegalStateException();
        }
        return this.m_value instanceof byte[];
    }

    @Override
    public byte[] getBytes() {
        if (this.m_event != JsonParser.Event.VALUE_STRING) {
            throw new IllegalStateException();
        }
        if (this.m_value instanceof byte[]) {
            return (byte[])this.m_value;
        }
        throw new IllegalStateException();
    }

    public boolean isIntegralNumber() {
        if (this.m_event != JsonParser.Event.VALUE_NUMBER) {
            throw new IllegalStateException();
        }
        return !(this.m_value instanceof Double);
    }

    public int getInt() {
        if (this.m_event != JsonParser.Event.VALUE_NUMBER) {
            throw new IllegalStateException();
        }
        return ((Number)this.m_value).intValue();
    }

    public long getLong() {
        if (this.m_event != JsonParser.Event.VALUE_NUMBER) {
            throw new IllegalStateException();
        }
        return ((Number)this.m_value).longValue();
    }

    public BigDecimal getBigDecimal() {
        if (this.m_event != JsonParser.Event.VALUE_NUMBER) {
            throw new IllegalStateException();
        }
        if (this.m_value instanceof Integer) {
            return new BigDecimal((Integer)this.m_value);
        }
        if (this.m_value instanceof Long) {
            return new BigDecimal((Long)this.m_value);
        }
        return new BigDecimal((Double)this.m_value);
    }

    public JsonLocation getLocation() {
        return this.m_location;
    }

    public void close() {
        try {
            this.m_states.clear();
            this.m_is.close();
        }
        catch (IOException ex) {
            throw new JsonParsingException(ex.getMessage(), (Throwable)ex, (JsonLocation)this.m_location);
        }
    }

    public boolean isRootAsArray() {
        return this.m_rootAsArray;
    }

    public void setRootAsArray(boolean b) {
        this.m_rootAsArray = b;
    }

    public int getBinaryFormat() {
        return this.m_binaryFormat;
    }

    public void setBinaryFormat(int binaryFormat) {
        this.m_binaryFormat = binaryFormat;
    }
}

