/*
 * Decompiled with CFR 0.152.
 */
package org.yuanheng.cookjson;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.json.JsonException;
import org.yuanheng.cookjson.BOM;

class BsonInputStream {
    static final int m_max = 8192;
    private final byte[] m_buffer = new byte[8192];
    private int m_readPos;
    private int m_readMax;
    private InputStream m_is;
    private byte[] m_strBuffer;
    private long m_location;

    public BsonInputStream(InputStream is) {
        this.m_is = is;
    }

    private void fill() throws IOException {
        this.m_readPos = 0;
        this.m_readMax = this.m_is.read(this.m_buffer);
        if (this.m_readMax <= 0) {
            this.ioError("unexpected eof.");
        }
    }

    private void ioError(String msg) {
        throw new JsonException("Offset " + this.m_location + ": " + msg);
    }

    public void readFully(byte[] b) throws IOException {
        int readSize;
        int off = 0;
        int len = b.length;
        this.m_location += (long)len;
        byte[] buf = this.m_buffer;
        int readPos = this.m_readPos;
        if (readPos + len < this.m_readMax) {
            for (int i = 0; i < len; ++i) {
                b[i] = buf[readPos++];
            }
            this.m_readPos = readPos;
            return;
        }
        int readMax = this.m_readMax;
        while (readPos < readMax) {
            b[off++] = buf[readPos++];
        }
        InputStream is = this.m_is;
        len -= off;
        do {
            if ((readSize = is.read(b, off, len)) < 0) {
                throw new EOFException();
            }
            off += readSize;
        } while ((len -= readSize) > 0);
        this.m_readPos = 0;
        this.m_readMax = 0;
    }

    public boolean readBoolean() throws IOException {
        if (this.m_readPos >= this.m_readMax) {
            this.fill();
        }
        ++this.m_location;
        return this.m_buffer[this.m_readPos++] != 0;
    }

    public byte read() throws IOException {
        if (this.m_readPos >= this.m_readMax) {
            this.fill();
        }
        ++this.m_location;
        return this.m_buffer[this.m_readPos++];
    }

    public int readInt() throws IOException {
        return this.read() & 0xFF | (this.read() & 0xFF) << 8 | (this.read() & 0xFF) << 16 | (this.read() & 0xFF) << 24;
    }

    public long readLong() throws IOException {
        return (long)this.readInt() & 0xFFFFFFFFL | (long)this.readInt() << 32;
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readCString() throws IOException {
        int readPos;
        byte[] strBuf = this.m_strBuffer;
        if (strBuf == null) {
            this.m_strBuffer = strBuf = new byte[200];
        }
        int bufferLen = strBuf.length;
        int pos = 0;
        byte[] buf = this.m_buffer;
        block0: while (true) {
            readPos = this.m_readPos;
            int readMax = this.m_readMax;
            while (readPos < readMax) {
                byte b;
                if ((b = buf[readPos++]) == 0) break block0;
                if (pos >= bufferLen) {
                    bufferLen += bufferLen / 2;
                    byte[] newBuffer = new byte[bufferLen];
                    System.arraycopy(strBuf, 0, newBuffer, 0, pos);
                    this.m_strBuffer = strBuf = newBuffer;
                }
                strBuf[pos++] = b;
            }
            this.fill();
        }
        this.m_readPos = readPos;
        this.m_location += (long)(pos + 1);
        if (pos == 0) {
            return "";
        }
        return new String(strBuf, 0, pos, BOM.utf8);
    }

    public String getStringValue() throws IOException {
        int size = this.readInt();
        byte[] bytes = new byte[size];
        this.readFully(bytes);
        return new String(bytes, 0, size - 1, BOM.utf8);
    }

    public byte[] getBinary() throws IOException {
        int size = this.readInt();
        this.read();
        byte[] bytes = new byte[size];
        this.readFully(bytes);
        return bytes;
    }

    public byte[] getObjectId() throws IOException {
        byte[] bytes = new byte[12];
        this.readFully(bytes);
        return bytes;
    }

    public void close() throws IOException {
        this.m_is.close();
    }

    public long getLocation() {
        return this.m_location;
    }
}

