/*
 * Decompiled with CFR 0.152.
 */
package org.yuanheng.cookjson;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerationException;
import javax.json.stream.JsonGenerator;
import org.yuanheng.cookjson.BOM;
import org.yuanheng.cookjson.CookJsonGenerator;
import org.yuanheng.cookjson.Utils;
import org.yuanheng.cookjson.value.CookJsonBinary;

public class BsonGenerator
implements CookJsonGenerator {
    private static final byte[] DIGITS = "0123456789".getBytes();
    private final OutputStream m_os;
    private static final int m_max = 8192;
    private final byte[] m_buffer = new byte[8193];
    private int m_pos;
    private static final int m_valueLen = 22;
    private final byte[] m_bytes = new byte[22];
    final ArrayList<Boolean> m_states = new ArrayList();
    private int m_state = 0;
    private final ArrayList<Integer> m_arrayCounts = new ArrayList();
    private String m_name;
    private int m_index;
    private boolean m_useDouble;

    public BsonGenerator(OutputStream os) {
        this.m_os = os;
    }

    public void setUseDouble(boolean b) {
        this.m_useDouble = b;
    }

    private void w(byte[] bytes) throws IOException {
        this.w(bytes, 0, bytes.length);
    }

    private void w(byte[] bytes, int offset, int length) throws IOException {
        int pos = this.m_pos;
        byte[] buf = this.m_buffer;
        if (pos + length < 8192) {
            for (int i = 0; i < length; ++i) {
                buf[pos++] = bytes[offset++];
            }
            this.m_pos = pos;
            return;
        }
        int len = 8192 - pos;
        while (pos < 8192) {
            buf[pos++] = bytes[offset++];
        }
        this.m_os.write(buf, 0, 8192);
        length -= len;
        while (length > 8192) {
            this.m_os.write(bytes, offset, 8192);
            offset += 8192;
            length -= 8192;
        }
        for (int i = 0; i < length; ++i) {
            buf[i] = bytes[offset++];
        }
        this.m_pos = length;
    }

    void w(int b) throws IOException {
        byte[] buf = this.m_buffer;
        int pos = this.m_pos;
        buf[pos++] = (byte)b;
        if (pos >= 8192) {
            this.m_os.write(buf, 0, pos);
            this.m_pos = 0;
        } else {
            this.m_pos = pos;
        }
    }

    private void wi(int value) throws IOException {
        byte[] buf = this.m_bytes;
        int pos = 22;
        buf[--pos] = 0;
        do {
            int v = value / 10;
            int r = value - v * 10;
            value = v;
            buf[--pos] = DIGITS[r];
        } while (value > 0);
        this.w(buf, pos, 22 - pos);
    }

    private void checkName(String name) {
        if (name.indexOf(0) >= 0) {
            throw new IllegalArgumentException("Name string contains \\0.");
        }
        this.m_name = name;
    }

    private void writeCString(String name) throws IOException {
        if (name == null) {
            this.wi(this.m_index++);
        } else if (name.length() == 0) {
            this.w(0);
        } else {
            byte[] bytes = name.getBytes(BOM.utf8);
            this.w(bytes);
            this.w(0);
        }
    }

    private JsonGenerator writeElement(int type, String name, int length) {
        try {
            this.w(type);
            this.writeCString(name);
            this.w(this.m_bytes, 0, length);
        }
        catch (IOException ex) {
            throw new JsonGenerationException(ex.getMessage(), (Throwable)ex);
        }
        return this;
    }

    private JsonGenerator writeRootObject() {
        try {
            this.w(this.m_bytes, 0, 4);
        }
        catch (IOException ex) {
            throw new JsonGenerationException(ex.getMessage(), (Throwable)ex);
        }
        return this;
    }

    private JsonGenerator writeObject(boolean root) {
        this.pushState(false);
        Utils.setInt(this.m_bytes, 0);
        if (root) {
            return this.writeRootObject();
        }
        return this.writeElement(3, this.m_name, 4);
    }

    private JsonGenerator writeArray(boolean root) {
        this.pushState(true);
        Utils.setInt(this.m_bytes, 0);
        if (root) {
            this.m_arrayCounts.add(0);
            this.m_index = 0;
            this.writeRootObject();
            this.m_name = null;
            return this;
        }
        this.writeElement(4, this.m_name, 4);
        this.m_arrayCounts.add(this.m_index);
        this.m_index = 0;
        this.m_name = null;
        return this;
    }

    private JsonGenerator writeValue(byte[] value) {
        try {
            Utils.setInt(this.m_bytes, value.length);
            this.writeElement(5, this.m_name, 4);
            this.w(0);
            this.w(value);
        }
        catch (IOException ex) {
            throw new JsonGenerationException(ex.getMessage(), (Throwable)ex);
        }
        return this;
    }

    private JsonGenerator writeValue(String value) {
        byte[] bytes = value.getBytes(BOM.utf8);
        Utils.setInt(this.m_bytes, bytes.length + 1);
        this.writeElement(2, this.m_name, 4);
        try {
            this.w(bytes);
            this.w(0);
        }
        catch (IOException ex) {
            throw new JsonGenerationException(ex.getMessage(), (Throwable)ex);
        }
        return this;
    }

    private JsonGenerator writeValue(int value) {
        Utils.setInt(this.m_bytes, value);
        return this.writeElement(16, this.m_name, 4);
    }

    private JsonGenerator writeValue(long value) {
        Utils.setLong(this.m_bytes, value);
        return this.writeElement(18, this.m_name, 8);
    }

    private JsonGenerator writeValue(double value) {
        long v = Double.doubleToLongBits(value);
        Utils.setLong(this.m_bytes, v);
        return this.writeElement(1, this.m_name, 8);
    }

    private JsonGenerator writeValue(boolean value) {
        this.m_bytes[0] = (byte)(value ? 1 : 0);
        return this.writeElement(8, this.m_name, 1);
    }

    private JsonGenerator writeNullValue() {
        try {
            this.w(10);
            this.writeCString(this.m_name);
        }
        catch (IOException ex) {
            throw new JsonGenerationException(ex.getMessage(), (Throwable)ex);
        }
        return this;
    }

    private JsonGenerator writeValue(JsonValue value) {
        switch (value.getValueType()) {
            case ARRAY: {
                JsonArray array = (JsonArray)value;
                this.writeArray(this.m_state == 0);
                for (JsonValue v : array) {
                    this.m_name = null;
                    this.writeValue(v);
                }
                this.writeEnd();
                break;
            }
            case OBJECT: {
                JsonObject obj = (JsonObject)value;
                this.writeObject(this.m_state == 0);
                for (Map.Entry entry : obj.entrySet()) {
                    this.m_name = (String)entry.getKey();
                    JsonValue v = (JsonValue)entry.getValue();
                    this.writeValue(v);
                }
                this.writeEnd();
                break;
            }
            case NULL: {
                return this.writeNullValue();
            }
            case NUMBER: {
                JsonNumber number = (JsonNumber)value;
                if (number.isIntegral()) {
                    try {
                        return this.writeValue(number.intValueExact());
                    }
                    catch (ArithmeticException ex) {
                        try {
                            return this.writeValue(number.longValueExact());
                        }
                        catch (ArithmeticException ex2) {
                            if (this.m_useDouble) {
                                return this.writeValue(number.doubleValue());
                            }
                            return this.writeValue(number.toString());
                        }
                    }
                }
                if (this.m_useDouble) {
                    return this.writeValue(number.doubleValue());
                }
                return this.writeValue(number.toString());
            }
            case STRING: {
                if (value instanceof CookJsonBinary) {
                    return this.writeValue(((CookJsonBinary)value).getBytes());
                }
                return this.writeValue(((JsonString)value).getString());
            }
            case TRUE: {
                return this.writeValue(true);
            }
            case FALSE: {
                return this.writeValue(false);
            }
        }
        return this;
    }

    public JsonGenerator writeStartObject() {
        if (this.m_state != 0 && this.m_state != 1) {
            throw new JsonGenerationException("This method is not called within a valid context.");
        }
        return this.writeObject(this.m_state == 0);
    }

    public JsonGenerator writeStartObject(String name) {
        if (this.m_state != 2) {
            throw new JsonGenerationException("This method is not called within an object context.");
        }
        this.checkName(name);
        return this.writeObject(false);
    }

    public JsonGenerator writeStartArray() {
        if (this.m_state != 0 && this.m_state != 1) {
            throw new JsonGenerationException("This method is not called within a valid context.");
        }
        return this.writeArray(this.m_state == 0);
    }

    public JsonGenerator writeStartArray(String name) {
        if (this.m_state != 2) {
            throw new JsonGenerationException("This method is not called within an object context.");
        }
        this.checkName(name);
        return this.writeArray(false);
    }

    public JsonGenerator write(String name, JsonValue value) {
        if (this.m_state != 2) {
            throw new JsonGenerationException("This method is not called within an object context.");
        }
        this.checkName(name);
        return this.writeValue(value);
    }

    @Override
    public JsonGenerator write(String name, byte[] value) {
        if (this.m_state != 2) {
            throw new JsonGenerationException("This method is not called within an object context.");
        }
        this.checkName(name);
        return this.writeValue(value);
    }

    public JsonGenerator write(String name, String value) {
        if (this.m_state != 2) {
            throw new JsonGenerationException("This method is not called within an object context.");
        }
        this.checkName(name);
        return this.writeValue(value);
    }

    public JsonGenerator write(String name, BigInteger value) {
        if (this.m_state != 2) {
            throw new JsonGenerationException("This method is not called within an object context.");
        }
        this.checkName(name);
        if (this.m_useDouble) {
            return this.writeValue(value.doubleValue());
        }
        return this.writeValue(value.toString());
    }

    public JsonGenerator write(String name, BigDecimal value) {
        if (this.m_state != 2) {
            throw new JsonGenerationException("This method is not called within an object context.");
        }
        this.checkName(name);
        if (this.m_useDouble) {
            return this.writeValue(value.doubleValue());
        }
        return this.writeValue(value.toString());
    }

    public JsonGenerator write(String name, int value) {
        if (this.m_state != 2) {
            throw new JsonGenerationException("This method is not called within an object context.");
        }
        this.checkName(name);
        return this.writeValue(value);
    }

    public JsonGenerator write(String name, long value) {
        if (this.m_state != 2) {
            throw new JsonGenerationException("This method is not called within an object context.");
        }
        this.checkName(name);
        return this.writeValue(value);
    }

    public JsonGenerator write(String name, double value) {
        if (this.m_state != 2) {
            throw new JsonGenerationException("This method is not called within an object context.");
        }
        this.checkName(name);
        return this.writeValue(value);
    }

    public JsonGenerator write(String name, boolean value) {
        if (this.m_state != 2) {
            throw new JsonGenerationException("This method is not called within an object context.");
        }
        this.checkName(name);
        return this.writeValue(value);
    }

    public JsonGenerator writeNull(String name) {
        if (this.m_state != 2) {
            throw new JsonGenerationException("This method is not called within an object context.");
        }
        this.checkName(name);
        return this.writeNullValue();
    }

    public JsonGenerator writeEnd() {
        boolean isArray = this.popState();
        if (isArray) {
            this.m_index = this.m_arrayCounts.remove(this.m_arrayCounts.size() - 1);
        }
        try {
            this.w(0);
            this.m_name = null;
        }
        catch (IOException ex) {
            throw new JsonGenerationException(ex.getMessage(), (Throwable)ex);
        }
        return this;
    }

    public JsonGenerator write(JsonValue value) {
        if (this.m_state != 1) {
            if (this.m_state == 0) {
                if (!(value instanceof JsonArray) && !(value instanceof JsonObject)) {
                    throw new JsonGenerationException("This method is not called within a valid context.");
                }
            } else {
                throw new JsonGenerationException("This method is not called within an array context.");
            }
        }
        return this.writeValue(value);
    }

    @Override
    public JsonGenerator write(byte[] value) {
        if (this.m_state != 1) {
            throw new JsonGenerationException("This method is not called within an array context.");
        }
        return this.writeValue(value);
    }

    public JsonGenerator write(String value) {
        if (this.m_state != 1) {
            throw new JsonGenerationException("This method is not called within an array context.");
        }
        return this.writeValue(value);
    }

    public JsonGenerator write(BigDecimal value) {
        if (this.m_state != 1) {
            throw new JsonGenerationException("This method is not called within an array context.");
        }
        if (this.m_useDouble) {
            return this.writeValue(value.doubleValue());
        }
        return this.writeValue(value.toString());
    }

    public JsonGenerator write(BigInteger value) {
        if (this.m_state != 1) {
            throw new JsonGenerationException("This method is not called within an array context.");
        }
        if (this.m_useDouble) {
            return this.writeValue(value.doubleValue());
        }
        return this.writeValue(value.toString());
    }

    public JsonGenerator write(int value) {
        if (this.m_state != 1) {
            throw new JsonGenerationException("This method is not called within an array context.");
        }
        return this.writeValue(value);
    }

    public JsonGenerator write(long value) {
        if (this.m_state != 1) {
            throw new JsonGenerationException("This method is not called within an array context.");
        }
        return this.writeValue(value);
    }

    public JsonGenerator write(double value) {
        if (this.m_state != 1) {
            throw new JsonGenerationException("This method is not called within an array context.");
        }
        return this.writeValue(value);
    }

    public JsonGenerator write(boolean value) {
        if (this.m_state != 1) {
            throw new JsonGenerationException("This method is not called within an array context.");
        }
        return this.writeValue(value);
    }

    public JsonGenerator writeNull() {
        if (this.m_state != 1) {
            throw new JsonGenerationException("This method is not called within an array context.");
        }
        return this.writeNullValue();
    }

    public void close() {
        try {
            this.flush();
            this.m_os.close();
        }
        catch (IOException ex) {
            throw new JsonGenerationException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void flush() {
        try {
            if (this.m_pos > 0) {
                this.m_os.write(this.m_buffer, 0, this.m_pos);
                this.m_pos = 0;
            }
            this.m_os.flush();
        }
        catch (IOException ex) {
            throw new JsonGenerationException(ex.getMessage(), (Throwable)ex);
        }
    }

    void pushState(boolean isArray) {
        this.m_state = isArray ? 1 : 2;
        this.m_states.add(isArray);
    }

    boolean popState() {
        ArrayList<Boolean> states = this.m_states;
        int index = states.size() - 1;
        boolean isArray = states.remove(index);
        this.m_state = index == 0 ? -1 : (states.get(index - 1) != false ? 1 : 2);
        return isArray;
    }
}

