/*
 * Decompiled with CFR 0.152.
 */
package org.yuanheng.cookjson;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Stack;
import javax.json.stream.JsonParser;
import org.yuanheng.cookjson.BsonParser;
import org.yuanheng.cookjson.Utils;

public class BsonFixLength {
    private static void getOffsets(JsonParser p, ArrayList<Pair> pairs) throws IOException {
        Stack<Long> matches = new Stack<Long>();
        boolean firstObject = true;
        boolean justStarted = false;
        block5: while (p.hasNext()) {
            long offset;
            JsonParser.Event e = p.next();
            switch (e) {
                case START_ARRAY: 
                case START_OBJECT: {
                    if (firstObject) {
                        offset = p.getLocation().getStreamOffset();
                        matches.push(offset);
                        firstObject = false;
                    }
                    justStarted = true;
                    continue block5;
                }
                case KEY_NAME: {
                    if (!justStarted) continue block5;
                    justStarted = false;
                    offset = p.getLocation().getStreamOffset();
                    matches.push(offset - 4L);
                    continue block5;
                }
                case END_ARRAY: 
                case END_OBJECT: {
                    long start;
                    offset = p.getLocation().getStreamOffset() + 1L;
                    if (justStarted) {
                        start = offset - 5L;
                        justStarted = false;
                    } else {
                        start = (Long)matches.pop();
                    }
                    Pair pair = new Pair();
                    pair.offset = start;
                    pair.size = (int)(offset - start);
                    pairs.add(pair);
                    continue block5;
                }
            }
            if (!justStarted) continue;
            justStarted = false;
            offset = p.getLocation().getStreamOffset();
            matches.push(offset - 4L);
        }
    }

    public static void fix(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        BsonParser p = new BsonParser(is);
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        BsonFixLength.getOffsets(p, pairs);
        p.close();
        Object[] pa = pairs.toArray(new Pair[pairs.size()]);
        Arrays.sort(pa);
        byte[] bytes = new byte[4];
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        RandomAccessFile f = new RandomAccessFile(file, "rw");
        FileChannel channel = f.getChannel();
        for (int i = 0; i < pairs.size(); ++i) {
            Utils.setInt(bytes, ((Pair)pa[i]).size);
            channel.write(buffer, ((Pair)pa[i]).offset);
            buffer.position(0);
        }
        f.close();
    }

    private static class Pair
    implements Comparable<Pair> {
        long offset;
        int size;

        private Pair() {
        }

        @Override
        public int compareTo(Pair o) {
            long diff = this.offset - o.offset;
            return diff > 0L ? 1 : (diff < 0L ? -1 : 0);
        }

        public String toString() {
            return this.offset + ": " + this.size;
        }
    }
}

