/*
 * Decompiled with CFR 0.152.
 */
package org.yuanheng.cookjson;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import javax.json.JsonException;
import javax.json.stream.JsonGenerator;
import org.yuanheng.cookjson.BsonGenerator;
import org.yuanheng.cookjson.BsonParser;
import org.yuanheng.cookjson.ConfigHandler;
import org.yuanheng.cookjson.CookJsonParser;

class BsonConfigHandler
implements ConfigHandler {
    private static final ConfigHandler s_instance = new BsonConfigHandler();

    public static ConfigHandler getInstance() {
        return s_instance;
    }

    private BsonConfigHandler() {
    }

    @Override
    public CookJsonParser createParser(Map<String, ?> config, Reader reader) {
        throw new JsonException("Cannot create a BSON parser from a Reader.");
    }

    @Override
    public CookJsonParser createParser(Map<String, ?> config, InputStream is) {
        BsonParser p = new BsonParser(is);
        boolean rootAsArray = false;
        Object obj = config.get("rootAsArray");
        if (obj != null) {
            rootAsArray = "true".equals(obj.toString());
        }
        p.setRootAsArray(rootAsArray);
        int binaryFormat = 0;
        obj = config.get("binaryFormat");
        if (obj != null && "hex".equals(obj.toString())) {
            binaryFormat = 1;
        }
        p.setBinaryFormat(binaryFormat);
        return p;
    }

    @Override
    public CookJsonParser createParser(Map<String, ?> config, InputStream is, Charset charset) {
        return this.createParser(config, is);
    }

    @Override
    public JsonGenerator createGenerator(Map<String, ?> config, Writer writer) {
        throw new JsonException("Cannot create a BSON generator from a Writer.");
    }

    @Override
    public JsonGenerator createGenerator(Map<String, ?> config, OutputStream os) {
        BsonGenerator g = new BsonGenerator(os);
        boolean writeDouble = false;
        Object obj = config.get("useDouble");
        if (obj != null) {
            writeDouble = "true".equals(obj.toString());
        }
        g.setUseDouble(writeDouble);
        return g;
    }

    @Override
    public JsonGenerator createGenerator(Map<String, ?> config, OutputStream os, Charset charset) {
        return this.createGenerator(config, os);
    }
}

