/*
 * Decompiled with CFR 0.152.
 */
package org.yuanheng.cookjson;

import java.io.IOException;
import java.io.PushbackInputStream;
import java.nio.charset.Charset;

public class BOM {
    public static final Charset utf8 = Charset.forName("utf-8");
    public static final Charset utf16le = Charset.forName("utf-16le");
    public static final Charset utf16be = Charset.forName("utf-16be");
    public static final Charset utf32le = Charset.forName("utf-32le");
    public static final Charset utf32be = Charset.forName("utf-32be");

    public static Charset guessCharset(PushbackInputStream is) throws IOException {
        int b1 = is.read();
        if (b1 < 0) {
            throw new IOException("JSON minimum size is 2");
        }
        int b2 = is.read();
        if (b2 < 0) {
            throw new IOException("JSON minimum size is 2");
        }
        if (b1 == 0) {
            is.unread(b2);
            is.unread(b1);
            if (b2 == 0) {
                return utf32be;
            }
            return utf16be;
        }
        if (b2 == 0) {
            int b3 = is.read();
            if (b3 < 0) {
                throw new IOException("Not a json file.");
            }
            is.unread(b3);
            is.unread(b2);
            is.unread(b1);
            if (b3 == 0) {
                return utf32le;
            }
            return utf16le;
        }
        is.unread(b2);
        is.unread(b1);
        return utf8;
    }
}

