/*
 * Decompiled with CFR 0.152.
 */
package org.yggd.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yggd.server.EmbeddedServer;
import org.yggd.server.EmbeddedServerBuilder;

public class TcpEmbeddedServerBuilder
implements EmbeddedServerBuilder {
    private int port;
    private Supplier<byte[]> active;
    private Consumer<byte[]> read;
    private boolean closeFromServer = false;

    TcpEmbeddedServerBuilder() {
    }

    public TcpEmbeddedServerBuilder port(int port) {
        this.port = port;
        return this;
    }

    public TcpEmbeddedServerBuilder active(Supplier<byte[]> active) {
        this.active = active;
        return this;
    }

    public TcpEmbeddedServerBuilder read(Consumer<byte[]> read) {
        this.read = read;
        return this;
    }

    public TcpEmbeddedServerBuilder closeFromServer(boolean closeFromServer) {
        this.closeFromServer = closeFromServer;
        return this;
    }

    public EmbeddedServer build() {
        TcpServerImpl tcpServer = new TcpServerImpl(this.port);
        tcpServer.active(this.active);
        tcpServer.read(this.read);
        tcpServer.setCloseFromServer(this.closeFromServer);
        return tcpServer;
    }

    private static class TcpServerHandler
    extends ChannelInboundHandlerAdapter {
        private static final Logger logger = LoggerFactory.getLogger(TcpServerHandler.class);
        private final Supplier<byte[]> active;
        private final Consumer<byte[]> read;
        private final boolean closeFromServer;

        private TcpServerHandler(Supplier<byte[]> active, Consumer<byte[]> read, boolean closeFromServer) {
            this.active = active;
            this.read = read;
            this.closeFromServer = closeFromServer;
        }

        public void channelActive(ChannelHandlerContext ctx) {
            ctx.writeAndFlush((Object)Unpooled.copiedBuffer((byte[])this.active.get()));
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            byte[] array;
            ByteBuf buf = (ByteBuf)msg;
            if (buf.hasArray()) {
                array = buf.array();
            } else {
                array = new byte[buf.readableBytes()];
                buf.getBytes(buf.readerIndex(), array);
            }
            this.read.accept(array);
        }

        public void channelReadComplete(ChannelHandlerContext ctx) {
            if (this.closeFromServer) {
                ctx.close();
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            logger.error("exception occurs.", cause);
            ctx.close();
        }
    }

    public static class TcpServerImpl
    implements EmbeddedServer {
        private final int port;
        private volatile boolean isRunning = false;
        private final EventLoopGroup group = new NioEventLoopGroup();
        private Supplier<byte[]> activeCallback;
        private Consumer<byte[]> readCallback;
        private boolean closeFromServer;

        private TcpServerImpl(int port) {
            this.port = port;
        }

        private void active(Supplier<byte[]> active) {
            this.activeCallback = active;
        }

        private void read(Consumer<byte[]> read) {
            this.readCallback = read;
        }

        private void setCloseFromServer(boolean closeFromServer) {
            this.closeFromServer = closeFromServer;
        }

        @Override
        public void start() {
            ServerBootstrap bootstrap = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.group).channel(NioServerSocketChannel.class)).localAddress((SocketAddress)new InetSocketAddress(this.port))).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{new TcpServerHandler(activeCallback, readCallback, closeFromServer)});
                }
            });
            try {
                bootstrap.bind().sync();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.isRunning = true;
        }

        @Override
        public void stop() {
            try {
                this.isRunning = false;
                this.group.shutdownGracefully().sync();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public boolean isRunning() {
            return this.isRunning;
        }
    }
}

