/*
 * Decompiled with CFR 0.152.
 */
package org.yggd.client.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Properties;
import org.springframework.core.io.Resource;
import org.yggd.client.sftp.SftpClient;
import org.yggd.client.sftp.SftpClientImpl;

public class SftpClientBuilder {
    private final String host;
    private final int port;
    private final JSch jSch = new JSch();
    private String username;
    private Properties properties = new Properties();
    private File privateKey;
    private SftpClient client;

    public SftpClientBuilder(String host, int port) {
        this.host = host;
        this.port = port;
        this.properties.put("StrictHostKeyChecking", "no");
    }

    public SftpClientBuilder username(String username) {
        this.username = username;
        return this;
    }

    public SftpClientBuilder property(Object key, Object value) {
        this.properties.put(key, value);
        return this;
    }

    public SftpClientBuilder privateKey(Path path) {
        return this.privateKey(path.toFile().getAbsolutePath());
    }

    public SftpClientBuilder privateKey(String privateKey) {
        try {
            this.jSch.addIdentity(this.resourceToFile(privateKey).getAbsolutePath());
        }
        catch (JSchException e) {
            throw new IllegalArgumentException(e);
        }
        return this;
    }

    public SftpClientBuilder privateKey(Resource resource, String passphrase) {
        try {
            return this.privateKey(resource.getFile(), passphrase);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public SftpClientBuilder privateKey(File file, String passphrase) {
        return this.privateKey(file.getAbsolutePath(), passphrase);
    }

    public SftpClientBuilder privateKey(String privateKey, String passphrase) {
        try {
            this.jSch.addIdentity(privateKey, passphrase.getBytes());
        }
        catch (JSchException e) {
            throw new IllegalArgumentException(e);
        }
        return this;
    }

    public SftpClientImpl build() {
        Session session = this.createSession();
        assert (session != null);
        return new SftpClientImpl(session, this.createChannel(session));
    }

    private Session createSession() {
        try {
            Session session = this.jSch.getSession(this.username, this.host, this.port);
            session.setConfig(this.properties);
            session.connect();
            return session;
        }
        catch (JSchException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private ChannelSftp createChannel(Session session) {
        try {
            ChannelSftp channelSftp = (ChannelSftp)session.openChannel("sftp");
            channelSftp.connect();
            return channelSftp;
        }
        catch (JSchException e) {
            throw new IllegalStateException(e);
        }
    }

    private File resourceToFile(String resource) {
        try {
            return new File(SftpClientBuilder.class.getResource(resource).toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

