/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.rendering.internal.renderer.apt;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.internal.renderer.AbstractBlockRenderer;
import org.xwiki.rendering.renderer.PrintRendererFactory;

/**
 * Output APT syntax using Doxia's APT Sink.
 *
 * @version $Id: 8478c5d39ebb401239e3b3d5adeb51b0de396e68 $
 * @since 4.3M1
 */
@Component
@Named("apt/1.0")
@Singleton
public class APTBlockRenderer extends AbstractBlockRenderer
{
    /**
     * Create APT Renderer instances.
     */
    @Inject
    @Named("apt/1.0")
    private PrintRendererFactory aptRendererFactory;

    @Override
    protected PrintRendererFactory getPrintRendererFactory()
    {
        return this.aptRendererFactory;
    }
}
