package org.xtext.sublime.generator;

import com.google.inject.Injector;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.eclipse.emf.mwe2.runtime.Mandatory;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.generator.AbstractXtextGeneratorFragment;
import org.eclipse.xtext.xtext.generator.IXtextGeneratorLanguage;
import org.eclipse.xtext.xtext.generator.model.IXtextGeneratorFileSystemAccess;
import org.eclipse.xtext.xtext.generator.model.XtextGeneratorFileSystemAccess;

@SuppressWarnings("all")
public class SublimeFragment extends AbstractXtextGeneratorFragment {
  private String absolutePath;
  
  @Accessors({ AccessorType.PROTECTED_GETTER, AccessorType.PUBLIC_SETTER })
  private boolean override = false;
  
  private IXtextGeneratorFileSystemAccess outputLocation;
  
  @Override
  public void generate() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("# [PackageDev] target_format: plist, ext: tmLanguage");
    _builder.newLine();
    _builder.append("name: thomas ");
    IXtextGeneratorLanguage _language = this.getLanguage();
    List<String> _fileExtensions = _language.getFileExtensions();
    String _head = IterableExtensions.<String>head(_fileExtensions);
    _builder.append(_head, "");
    _builder.newLineIfNotEmpty();
    _builder.append("scopeName: source.");
    IXtextGeneratorLanguage _language_1 = this.getLanguage();
    List<String> _fileExtensions_1 = _language_1.getFileExtensions();
    String _head_1 = IterableExtensions.<String>head(_fileExtensions_1);
    _builder.append(_head_1, "");
    _builder.newLineIfNotEmpty();
    _builder.append("fileTypes: [");
    IXtextGeneratorLanguage _language_2 = this.getLanguage();
    List<String> _fileExtensions_2 = _language_2.getFileExtensions();
    String _head_2 = IterableExtensions.<String>head(_fileExtensions_2);
    _builder.append(_head_2, "");
    _builder.append("]");
    _builder.newLineIfNotEmpty();
    _builder.append("uuid: ");
    UUID _randomUUID = UUID.randomUUID();
    _builder.append(_randomUUID, "");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("patterns:");
    _builder.newLine();
    String _collectKeywordsAsRegex = this.collectKeywordsAsRegex();
    _builder.append(_collectKeywordsAsRegex, "");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    final String configFile = _builder.toString();
    this.outputLocation.generateFile(
      "newthomas.YAML-tmLanguage", configFile);
    StringConcatenation _builder_1 = new StringConcatenation();
    _builder_1.append("import sublime, sublime_plugin, urllib2, urllib, json");
    _builder_1.newLine();
    _builder_1.newLine();
    _builder_1.append("class GoogleAutocomplete(sublime_plugin.EventListener):");
    _builder_1.newLine();
    _builder_1.append("    ");
    _builder_1.append("def on_query_completions(self, view, prefix, locations):");
    _builder_1.newLine();
    _builder_1.append("        ");
    _builder_1.append("region = sublime.Region(0,view.size())");
    _builder_1.newLine();
    _builder_1.append("        ");
    _builder_1.append("content = view.substr(sublime.Region(0,view.size()))");
    _builder_1.newLine();
    _builder_1.append("        ");
    _builder_1.append("row = view.rowcol(locations[0])[0]");
    _builder_1.newLine();
    _builder_1.append("        ");
    _builder_1.append("col = view.rowcol(locations[0])[1]");
    _builder_1.newLine();
    _builder_1.append("        ");
    _builder_1.append("offset = view.text_point(row,col)");
    _builder_1.newLine();
    _builder_1.append("        ");
    _builder_1.append("data = {\'caretOffset\': offset ,\'fullText\': content }");
    _builder_1.newLine();
    _builder_1.append("        ");
    _builder_1.append("data = urllib.urlencode(data)");
    _builder_1.newLine();
    _builder_1.append("        ");
    _builder_1.append("filename = str(view.file_name()).split(\"/\")[-1]");
    _builder_1.newLine();
    _builder_1.append("        ");
    _builder_1.append("url=\'http://localhost:8081/xtext-service/assist?resource=\'+filename");
    _builder_1.newLine();
    _builder_1.append("        ");
    _builder_1.append("response = urllib2.urlopen(url,data)");
    _builder_1.newLine();
    _builder_1.append("        ");
    _builder_1.append("response = json.loads(response.read())[\'entries\']");
    _builder_1.newLine();
    _builder_1.append("        ");
    _builder_1.append("output = []");
    _builder_1.newLine();
    _builder_1.append("        ");
    _builder_1.append("for key, value in enumerate(response):");
    _builder_1.newLine();
    _builder_1.append("            ");
    _builder_1.append("output.append(self.create_completion(value[\"proposal\"],\"xtext\"))");
    _builder_1.newLine();
    _builder_1.append("        ");
    _builder_1.append("#output = [x[\'proposal\'] for x in response ]");
    _builder_1.newLine();
    _builder_1.append("        ");
    _builder_1.append("#output = [ \"hi\" ,\"hello \",\"hoho\"]");
    _builder_1.newLine();
    _builder_1.append("        ");
    _builder_1.append("print output");
    _builder_1.newLine();
    _builder_1.append("        ");
    _builder_1.append("return output");
    _builder_1.newLine();
    _builder_1.newLine();
    _builder_1.append("    ");
    _builder_1.append("def create_completion(self, var, location):");
    _builder_1.newLine();
    _builder_1.append("        ");
    _builder_1.append("return (var + \'\\t\' + location, var)");
    _builder_1.newLine();
    final String auto_complete_plugin = _builder_1.toString();
    this.outputLocation.generateFile(
      "xtext_autocomplete.py", auto_complete_plugin);
    StringConcatenation _builder_2 = new StringConcatenation();
    _builder_2.append("import sublime, sublime_plugin,subprocess,urllib2,urllib,json");
    _builder_2.newLine();
    _builder_2.newLine();
    _builder_2.append("class FormatterCommand(sublime_plugin.TextCommand):");
    _builder_2.newLine();
    _builder_2.append("\t");
    _builder_2.append("def run(self, edit):");
    _builder_2.newLine();
    _builder_2.append("\t\t");
    _builder_2.append("region = sublime.Region(0,self.view.size())");
    _builder_2.newLine();
    _builder_2.append("\t\t");
    _builder_2.append("content = self.view.substr(sublime.Region(0,self.view.size()))");
    _builder_2.newLine();
    _builder_2.append("\t\t");
    _builder_2.append("data = {\'fullText\': content }");
    _builder_2.newLine();
    _builder_2.append("\t\t");
    _builder_2.append("data = urllib.urlencode(data)");
    _builder_2.newLine();
    _builder_2.append("\t\t");
    _builder_2.append("filename = str(self.view.file_name()).split(\"/\")[-1]");
    _builder_2.newLine();
    _builder_2.append("\t\t");
    _builder_2.append("url=\'http://localhost:8081/xtext-service/format?resource=\'+filename");
    _builder_2.newLine();
    _builder_2.append("\t\t");
    _builder_2.append("response = urllib2.urlopen(url,data)");
    _builder_2.newLine();
    _builder_2.append("\t\t");
    _builder_2.append("text = json.loads(response.read())[\'formattedText\']");
    _builder_2.newLine();
    _builder_2.append("\t\t");
    _builder_2.append("self.view.replace(edit,region,text)");
    _builder_2.newLine();
    final String formatter_plugin = _builder_2.toString();
    this.outputLocation.generateFile(
      "xtext_formatter.py", formatter_plugin);
    StringConcatenation _builder_3 = new StringConcatenation();
    _builder_3.append("[");
    _builder_3.newLine();
    _builder_3.append("    ");
    _builder_3.append("{ \"caption\": \"xtext_formatter\", \"command\": \"formatter\" }");
    _builder_3.newLine();
    _builder_3.append("]");
    _builder_3.newLine();
    final String formatter_commands = _builder_3.toString();
    this.outputLocation.generateFile(
      "xtext_formatter.sublime-commands", formatter_commands);
    StringConcatenation _builder_4 = new StringConcatenation();
    _builder_4.append("import sublime, sublime_plugin, urllib2, urllib, json");
    _builder_4.newLine();
    _builder_4.newLine();
    _builder_4.newLine();
    _builder_4.append("class ValidatorCommand(sublime_plugin.TextCommand):");
    _builder_4.newLine();
    _builder_4.append("\t");
    _builder_4.append("def run(self, edit):");
    _builder_4.newLine();
    _builder_4.append("\t\t");
    _builder_4.append("region = sublime.Region(0,self.view.size())");
    _builder_4.newLine();
    _builder_4.append("\t\t");
    _builder_4.append("self.view.add_regions(\"text\",[region],\"\")");
    _builder_4.newLine();
    _builder_4.append("\t\t");
    _builder_4.append("content = self.view.substr(sublime.Region(0,self.view.size()))");
    _builder_4.newLine();
    _builder_4.append("\t\t");
    _builder_4.append("data = {\'fullText\': content }");
    _builder_4.newLine();
    _builder_4.append("\t\t");
    _builder_4.append("data = urllib.urlencode(data)");
    _builder_4.newLine();
    _builder_4.append("\t\t");
    _builder_4.append("filename = str(self.view.file_name()).split(\"/\")[-1]");
    _builder_4.newLine();
    _builder_4.append("\t\t");
    _builder_4.append("url=\'http://localhost:8081/xtext-service/validate?resource=\'+filename");
    _builder_4.newLine();
    _builder_4.append("\t\t");
    _builder_4.append("response = urllib2.urlopen(url,data)");
    _builder_4.newLine();
    _builder_4.append("\t\t");
    _builder_4.append("self.view.insert(edit,self.view.size(),\"\\n\")");
    _builder_4.newLine();
    _builder_4.append("\t\t");
    _builder_4.append("response = json.loads(response.read())[\'issues\']");
    _builder_4.newLine();
    _builder_4.append("\t\t");
    _builder_4.append("for key, value in enumerate(response):");
    _builder_4.newLine();
    _builder_4.append("\t\t\t");
    _builder_4.append("for index,title in enumerate(value):");
    _builder_4.newLine();
    _builder_4.append("\t\t\t\t");
    _builder_4.append("self.view.insert(edit,self.view.size(),\"# \"+str(title)+\" : \"+str(value[title])+\"\\n\")");
    _builder_4.newLine();
    _builder_4.append("\t\t\t\t");
    _builder_4.append("if(title==\"offset\"):");
    _builder_4.newLine();
    _builder_4.append("\t\t\t\t\t");
    _builder_4.append("print(value[title])");
    _builder_4.newLine();
    _builder_4.append("\t\t\t\t\t");
    _builder_4.append("self.view.add_regions(str(key),[self.view.word(value[title])],\"invalid\")");
    _builder_4.newLine();
    _builder_4.append("\t\t\t");
    _builder_4.append("self.view.insert(edit,self.view.size(),\"\\n\")");
    _builder_4.newLine();
    final String validator_plugin = _builder_4.toString();
    this.outputLocation.generateFile(
      "xtext_validator.py", validator_plugin);
    StringConcatenation _builder_5 = new StringConcatenation();
    _builder_5.append("[");
    _builder_5.newLine();
    _builder_5.append("    ");
    _builder_5.append("{ \"caption\": \"xtext_validator\", \"command\": \"validator\" }");
    _builder_5.newLine();
    _builder_5.append("]");
    _builder_5.newLine();
    final String validator_commands = _builder_5.toString();
    this.outputLocation.generateFile(
      "xtext_validator.sublime-commands", validator_commands);
  }
  
  protected IXtextGeneratorFileSystemAccess getOutputLocation() {
    return this.outputLocation;
  }
  
  @Override
  public void initialize(final Injector injector) {
    super.initialize(injector);
    XtextGeneratorFileSystemAccess _xtextGeneratorFileSystemAccess = new XtextGeneratorFileSystemAccess(this.absolutePath, this.override);
    this.outputLocation = _xtextGeneratorFileSystemAccess;
    injector.injectMembers(this.outputLocation);
  }
  
  protected String getAbsolutePath() {
    return this.absolutePath;
  }
  
  @Mandatory
  public void setAbsolutePath(final String absolutePath) {
    this.absolutePath = absolutePath;
  }
  
  public String collectKeywordsAsRegex() {
    String _xblockexpression = null;
    {
      final Grammar g = this.getGrammar();
      final Set<String> keywords = GrammarUtil.getAllKeywords(g);
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("- name: keyword.other.");
      IXtextGeneratorLanguage _language = this.getLanguage();
      List<String> _fileExtensions = _language.getFileExtensions();
      String _head = IterableExtensions.<String>head(_fileExtensions);
      _builder.append(_head, "");
      _builder.newLineIfNotEmpty();
      _builder.append("  ");
      _builder.append("match: ");
      final String test = _builder.toString();
      final Function1<String, Boolean> _function = new Function1<String, Boolean>() {
        @Override
        public Boolean apply(final String it) {
          return Boolean.valueOf(it.matches("\\b\\w+\\b"));
        }
      };
      Iterable<String> _filter = IterableExtensions.<String>filter(keywords, _function);
      final Function1<String, CharSequence> _function_1 = new Function1<String, CharSequence>() {
        @Override
        public CharSequence apply(final String it) {
          return it;
        }
      };
      String _join = IterableExtensions.<String>join(_filter, 
        "\\b(", 
        "|", 
        ")\\b", _function_1);
      String _string = _join.toString();
      _xblockexpression = test.concat(_string);
    }
    return _xblockexpression;
  }
  
  @Pure
  protected boolean isOverride() {
    return this.override;
  }
  
  public void setOverride(final boolean override) {
    this.override = override;
  }
}
