/*
 * Decompiled with CFR 0.152.
 */
package org.xtext.gradle.android;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.AppPlugin;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.LibraryPlugin;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.TestVariant;
import com.android.build.gradle.internal.CompileOptions;
import com.android.build.gradle.internal.api.TestedVariant;
import com.android.build.gradle.tasks.AidlCompile;
import com.android.build.gradle.tasks.GenerateBuildConfig;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import com.android.build.gradle.tasks.RenderscriptCompile;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.xtext.gradle.XtextBuilderPlugin;
import org.xtext.gradle.XtextJavaLanguagePlugin;
import org.xtext.gradle.tasks.GeneratorConfig;
import org.xtext.gradle.tasks.XtextBuilderOptions;
import org.xtext.gradle.tasks.XtextExtension;
import org.xtext.gradle.tasks.XtextGenerate;
import org.xtext.gradle.tasks.XtextSourceDirectorySet;
import org.xtext.gradle.tasks.XtextSourceSetOutputs;

public class XtextAndroidBuilderPlugin
implements Plugin<Project> {
    private Project project;
    private XtextExtension xtext;
    private BaseExtension android;
    private DomainObjectSet<? extends BaseVariant> variants;

    public void apply(Project project) {
        XtextExtension _byType;
        this.project = project;
        Action _function = it -> {
            it.plugin(XtextBuilderPlugin.class);
            it.plugin(XtextJavaLanguagePlugin.class);
        };
        project.apply(_function);
        ExtensionContainer _extensions = project.getExtensions();
        this.xtext = _byType = (XtextExtension)_extensions.getByType(XtextExtension.class);
        PluginContainer _plugins = project.getPlugins();
        Action _function_1 = it -> this.configureAndroid();
        _plugins.withType(AppPlugin.class, _function_1);
        PluginContainer _plugins_1 = project.getPlugins();
        Action _function_2 = it -> this.configureAndroid();
        _plugins_1.withType(LibraryPlugin.class, _function_2);
    }

    private void configureAndroid() {
        ExtensionContainer _extensions = this.project.getExtensions();
        Object _byName = _extensions.getByName("android");
        this.android = (BaseExtension)_byName;
        Action _function = it -> {
            it.exclude("META-INF/ECLIPSE_.RSA");
            it.exclude("META-INF/ECLIPSE_.SF");
        };
        this.android.packagingOptions(_function);
        Action _function_1 = it -> {
            DomainObjectSet _switchResult = null;
            BaseExtension android = this.android;
            boolean _matched = false;
            if (!_matched && android instanceof AppExtension) {
                DomainObjectSet _applicationVariants;
                _matched = true;
                _switchResult = _applicationVariants = ((AppExtension)this.android).getApplicationVariants();
            }
            if (!_matched && android instanceof LibraryExtension) {
                _matched = true;
                _switchResult = ((LibraryExtension)this.android).getLibraryVariants();
            }
            if (!_matched) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"Unknown packaging type ");
                Class<?> _class = this.android.getClass();
                String _simpleName = _class.getSimpleName();
                _builder.append((Object)_simpleName, "");
                throw new GradleException(_builder.toString());
            }
            this.variants = _switchResult;
            this.configureOutletDefaults();
            this.configureGeneratorDefaults();
            this.configureSourceSetDefaults();
        };
        this.project.afterEvaluate(_function_1);
    }

    private void configureSourceSetDefaults() {
        Action _function = variant -> {
            this.configureSourceSetForVariant((BaseVariant)variant);
            if (variant instanceof TestedVariant) {
                boolean _tripleNotEquals;
                TestVariant _testVariant = ((TestedVariant)variant).getTestVariant();
                boolean bl = _tripleNotEquals = _testVariant != null;
                if (_tripleNotEquals) {
                    TestVariant _testVariant_1 = ((TestedVariant)variant).getTestVariant();
                    this.configureSourceSetForVariant((BaseVariant)_testVariant_1);
                }
            }
        };
        this.variants.all(_function);
    }

    private XtextSourceDirectorySet configureSourceSetForVariant(BaseVariant variant) {
        NamedDomainObjectContainer _sourceSets = this.xtext.getSourceSets();
        String _name = variant.getName();
        XtextSourceDirectorySet _maybeCreate = (XtextSourceDirectorySet)_sourceSets.maybeCreate(_name);
        Procedures.Procedure1 _function = sourceSet -> {
            TaskContainer _tasks = this.project.getTasks();
            String _generatorTaskName = sourceSet.getGeneratorTaskName();
            Task _byName = _tasks.getByName(_generatorTaskName);
            final XtextGenerate generatorTask = (XtextGenerate)_byName;
            AidlCompile _aidlCompile = variant.getAidlCompile();
            RenderscriptCompile _renderscriptCompile = variant.getRenderscriptCompile();
            GenerateBuildConfig _generateBuildConfig = variant.getGenerateBuildConfig();
            generatorTask.dependsOn(new Object[]{_aidlCompile, _renderscriptCompile, _generateBuildConfig});
            List _outputs = variant.getOutputs();
            Functions.Function1 _function_1 = it -> it.getProcessResources();
            List _map = ListExtensions.map((List)_outputs, (Functions.Function1)_function_1);
            generatorTask.dependsOn(new Object[]{_map});
            Task _javaCompiler = variant.getJavaCompiler();
            _javaCompiler.doLast((Action)new Action<Task>(){

                public void execute(Task it) {
                    if (it instanceof AbstractCompile) {
                        File _destinationDir = ((AbstractCompile)it).getDestinationDir();
                        generatorTask.installDebugInfo(_destinationDir);
                    }
                }
            });
            ArrayList sourceDirs = CollectionLiterals.newArrayList((Object[])new File[0]);
            List _sourceSets_1 = variant.getSourceSets();
            Functions.Function1 _function_2 = it -> it.getJavaDirectories();
            List _map_1 = ListExtensions.map((List)_sourceSets_1, (Functions.Function1)_function_2);
            Iterable _flatten = Iterables.concat((Iterable)_map_1);
            Functions.Function1 _function_3 = it -> it.isDirectory();
            Iterable javaDirs = IterableExtensions.filter((Iterable)_flatten, (Functions.Function1)_function_3);
            Iterables.addAll((Collection)sourceDirs, (Iterable)javaDirs);
            AidlCompile _aidlCompile_1 = variant.getAidlCompile();
            File _sourceOutputDir = _aidlCompile_1.getSourceOutputDir();
            GenerateBuildConfig _generateBuildConfig_1 = variant.getGenerateBuildConfig();
            File _sourceOutputDir_1 = _generateBuildConfig_1.getSourceOutputDir();
            RenderscriptCompile _renderscriptCompile_1 = variant.getRenderscriptCompile();
            File _sourceOutputDir_2 = _renderscriptCompile_1.getSourceOutputDir();
            Iterables.addAll((Collection)sourceDirs, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new File[]{_sourceOutputDir, _sourceOutputDir_1, _sourceOutputDir_2})));
            List _outputs_1 = variant.getOutputs();
            Functions.Function1 _function_4 = it -> {
                ProcessAndroidResources _processResources = it.getProcessResources();
                return _processResources.getSourceOutputDir();
            };
            List _map_2 = ListExtensions.map((List)_outputs_1, (Functions.Function1)_function_4);
            Iterables.addAll((Collection)sourceDirs, (Iterable)_map_2);
            sourceSet.srcDirs(new Object[]{sourceDirs});
            List _bootClasspath = this.android.getBootClasspath();
            ConfigurableFileCollection _files = this.project.files(new Object[]{_bootClasspath});
            generatorTask.setBootstrapClasspath((FileCollection)_files);
            Task _javaCompiler_1 = variant.getJavaCompiler();
            if (!(_javaCompiler_1 instanceof AbstractCompile)) {
                throw new GradleException("The Xtext plugin only supports using the javac compiler.");
            }
            Task _javaCompiler_2 = variant.getJavaCompiler();
            AbstractCompile compile = (AbstractCompile)_javaCompiler_2;
            FileCollection _classpath = compile.getClasspath();
            List _bootClasspath_1 = this.android.getBootClasspath();
            ConfigurableFileCollection _files_1 = this.project.files(new Object[]{_bootClasspath_1});
            FileCollection _plus = _classpath.plus((FileCollection)_files_1);
            generatorTask.setClasspath(_plus);
            XtextBuilderOptions _options = generatorTask.getOptions();
            CompileOptions _compileOptions = this.android.getCompileOptions();
            String _encoding = _compileOptions.getEncoding();
            _options.setEncoding(_encoding);
            Iterable _outputDirectories = generatorTask.getOutputDirectories();
            variant.registerJavaGeneratingTask((Task)generatorTask, (File[])Conversions.unwrapArray((Object)_outputDirectories, File.class));
        };
        return (XtextSourceDirectorySet)ObjectExtensions.operator_doubleArrow((Object)_maybeCreate, (Procedures.Procedure1)_function);
    }

    private void configureGeneratorDefaults() {
        NamedDomainObjectContainer _languages = this.xtext.getLanguages();
        Action _function = it -> {
            GeneratorConfig _generator = it.getGenerator();
            CompileOptions _compileOptions = this.android.getCompileOptions();
            JavaVersion _sourceCompatibility = _compileOptions.getSourceCompatibility();
            String _string = _sourceCompatibility.toString();
            _generator.setJavaSourceLevel(_string);
        };
        _languages.all(_function);
    }

    private void configureOutletDefaults() {
        NamedDomainObjectContainer _languages = this.xtext.getLanguages();
        Action _function = language -> {
            GeneratorConfig _generator = language.getGenerator();
            NamedDomainObjectContainer _outlets = _generator.getOutlets();
            Action _function_1 = outlet -> {
                NamedDomainObjectContainer _sourceSets = this.xtext.getSourceSets();
                Action _function_2 = sourceSet -> {
                    XtextSourceSetOutputs output = sourceSet.getOutput();
                    StringConcatenation _builder = new StringConcatenation();
                    File _buildDir = this.project.getBuildDir();
                    _builder.append((Object)_buildDir, "");
                    _builder.append((Object)"/generated/source/");
                    String _name = language.getName();
                    _builder.append((Object)_name, "");
                    String _folderFragment = outlet.getFolderFragment();
                    _builder.append((Object)_folderFragment, "");
                    _builder.append((Object)"/");
                    String _name_1 = sourceSet.getName();
                    _builder.append((Object)_name_1, "");
                    output.dir(outlet, (Object)_builder);
                };
                _sourceSets.all(_function_2);
            };
            _outlets.all(_function_1);
        };
        _languages.all(_function);
    }
}

