package org.xtext.gradle.android;

import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.ObjectConfigurationAction;
import org.xtext.gradle.XtendLanguageBasePlugin;
import org.xtext.gradle.android.XtextAndroidBuilderPlugin;
import org.xtext.gradle.protocol.GradleInstallDebugInfoRequest;
import org.xtext.gradle.tasks.DebuggerConfig;
import org.xtext.gradle.tasks.Language;
import org.xtext.gradle.tasks.XtextExtension;

@SuppressWarnings("all")
public class XtendAndroidBuilderPlugin implements Plugin<Project> {
  @Override
  public void apply(final Project project) {
    final Action<ObjectConfigurationAction> _function = (ObjectConfigurationAction it) -> {
      it.plugin(XtextAndroidBuilderPlugin.class);
      it.plugin(XtendLanguageBasePlugin.class);
    };
    project.apply(_function);
    ExtensionContainer _extensions = project.getExtensions();
    final XtextExtension xtext = _extensions.<XtextExtension>getByType(XtextExtension.class);
    NamedDomainObjectContainer<Language> _languages = xtext.getLanguages();
    Language _at = _languages.getAt("xtend");
    final Procedure1<Language> _function_1 = (Language it) -> {
      DebuggerConfig _debugger = it.getDebugger();
      final Procedure1<DebuggerConfig> _function_2 = (DebuggerConfig it_1) -> {
        it_1.setSourceInstaller(GradleInstallDebugInfoRequest.SourceInstaller.PRIMARY);
        it_1.setHideSyntheticVariables(false);
      };
      ObjectExtensions.<DebuggerConfig>operator_doubleArrow(_debugger, _function_2);
    };
    ObjectExtensions.<Language>operator_doubleArrow(_at, _function_1);
  }
}
