package org.xtext.gradle.android;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.AppPlugin;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.LibraryPlugin;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.api.TestVariant;
import com.android.build.gradle.internal.CompileOptions;
import com.android.build.gradle.internal.api.TestedVariant;
import com.android.build.gradle.tasks.AidlCompile;
import com.android.build.gradle.tasks.GenerateBuildConfig;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import com.android.build.gradle.tasks.RenderscriptCompile;
import com.android.builder.model.SourceProvider;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.ObjectConfigurationAction;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.xtext.gradle.XtextBuilderPlugin;
import org.xtext.gradle.XtextJavaLanguagePlugin;
import org.xtext.gradle.tasks.GeneratorConfig;
import org.xtext.gradle.tasks.Language;
import org.xtext.gradle.tasks.Outlet;
import org.xtext.gradle.tasks.XtextBuilderOptions;
import org.xtext.gradle.tasks.XtextExtension;
import org.xtext.gradle.tasks.XtextGenerate;
import org.xtext.gradle.tasks.XtextSourceDirectorySet;
import org.xtext.gradle.tasks.XtextSourceSetOutputs;

@SuppressWarnings("all")
public class XtextAndroidBuilderPlugin implements Plugin<Project> {
  private Project project;
  
  private XtextExtension xtext;
  
  private BaseExtension android;
  
  private DomainObjectSet<? extends BaseVariant> variants;
  
  @Override
  public void apply(final Project project) {
    this.project = project;
    final Action<ObjectConfigurationAction> _function = new Action<ObjectConfigurationAction>() {
      @Override
      public void execute(final ObjectConfigurationAction it) {
        it.plugin(XtextBuilderPlugin.class);
        it.plugin(XtextJavaLanguagePlugin.class);
      }
    };
    project.apply(_function);
    ExtensionContainer _extensions = project.getExtensions();
    XtextExtension _byType = _extensions.<XtextExtension>getByType(XtextExtension.class);
    this.xtext = _byType;
    PluginContainer _plugins = project.getPlugins();
    final Action<AppPlugin> _function_1 = new Action<AppPlugin>() {
      @Override
      public void execute(final AppPlugin it) {
        XtextAndroidBuilderPlugin.this.configureAndroid();
      }
    };
    _plugins.<AppPlugin>withType(AppPlugin.class, _function_1);
    PluginContainer _plugins_1 = project.getPlugins();
    final Action<LibraryPlugin> _function_2 = new Action<LibraryPlugin>() {
      @Override
      public void execute(final LibraryPlugin it) {
        XtextAndroidBuilderPlugin.this.configureAndroid();
      }
    };
    _plugins_1.<LibraryPlugin>withType(LibraryPlugin.class, _function_2);
  }
  
  private void configureAndroid() {
    final Action<Project> _function = new Action<Project>() {
      @Override
      public void execute(final Project it) {
        ExtensionContainer _extensions = XtextAndroidBuilderPlugin.this.project.getExtensions();
        Object _byName = _extensions.getByName("android");
        XtextAndroidBuilderPlugin.this.android = ((BaseExtension) _byName);
        DomainObjectSet<? extends BaseVariant> _switchResult = null;
        final BaseExtension android = XtextAndroidBuilderPlugin.this.android;
        boolean _matched = false;
        if (!_matched) {
          if (android instanceof AppExtension) {
            _matched=true;
            DomainObjectSet<ApplicationVariant> _applicationVariants = ((AppExtension)XtextAndroidBuilderPlugin.this.android).getApplicationVariants();
            _switchResult = ((DomainObjectSet<? extends BaseVariant>) _applicationVariants);
          }
        }
        if (!_matched) {
          if (android instanceof LibraryExtension) {
            _matched=true;
            _switchResult = ((LibraryExtension)XtextAndroidBuilderPlugin.this.android).getLibraryVariants();
          }
        }
        if (!_matched) {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("Unknown packaging type ");
          Class<? extends BaseExtension> _class = XtextAndroidBuilderPlugin.this.android.getClass();
          String _simpleName = _class.getSimpleName();
          _builder.append(_simpleName, "");
          throw new GradleException(_builder.toString());
        }
        XtextAndroidBuilderPlugin.this.variants = _switchResult;
        XtextAndroidBuilderPlugin.this.configureOutletDefaults();
        XtextAndroidBuilderPlugin.this.configureGeneratorDefaults();
        XtextAndroidBuilderPlugin.this.configureSourceSetDefaults();
      }
    };
    this.project.afterEvaluate(_function);
  }
  
  private void configureSourceSetDefaults() {
    final Action<BaseVariant> _function = new Action<BaseVariant>() {
      @Override
      public void execute(final BaseVariant variant) {
        XtextAndroidBuilderPlugin.this.configureSourceSetForVariant(variant);
        if ((variant instanceof TestedVariant)) {
          TestVariant _testVariant = ((TestedVariant)variant).getTestVariant();
          boolean _notEquals = (!Objects.equal(_testVariant, null));
          if (_notEquals) {
            TestVariant _testVariant_1 = ((TestedVariant)variant).getTestVariant();
            XtextAndroidBuilderPlugin.this.configureSourceSetForVariant(_testVariant_1);
          }
        }
      }
    };
    this.variants.all(_function);
  }
  
  private XtextSourceDirectorySet configureSourceSetForVariant(final BaseVariant variant) {
    NamedDomainObjectContainer<XtextSourceDirectorySet> _sourceSets = this.xtext.getSourceSets();
    String _name = variant.getName();
    XtextSourceDirectorySet _maybeCreate = _sourceSets.maybeCreate(_name);
    final Procedure1<XtextSourceDirectorySet> _function = new Procedure1<XtextSourceDirectorySet>() {
      @Override
      public void apply(final XtextSourceDirectorySet sourceSet) {
        TaskContainer _tasks = XtextAndroidBuilderPlugin.this.project.getTasks();
        String _generatorTaskName = sourceSet.getGeneratorTaskName();
        Task _byName = _tasks.getByName(_generatorTaskName);
        final XtextGenerate generatorTask = ((XtextGenerate) _byName);
        AidlCompile _aidlCompile = variant.getAidlCompile();
        RenderscriptCompile _renderscriptCompile = variant.getRenderscriptCompile();
        GenerateBuildConfig _generateBuildConfig = variant.getGenerateBuildConfig();
        generatorTask.dependsOn(_aidlCompile, _renderscriptCompile, _generateBuildConfig);
        List<BaseVariantOutput> _outputs = variant.getOutputs();
        final Function1<BaseVariantOutput, ProcessAndroidResources> _function = new Function1<BaseVariantOutput, ProcessAndroidResources>() {
          @Override
          public ProcessAndroidResources apply(final BaseVariantOutput it) {
            return it.getProcessResources();
          }
        };
        List<ProcessAndroidResources> _map = ListExtensions.<BaseVariantOutput, ProcessAndroidResources>map(_outputs, _function);
        generatorTask.dependsOn(_map);
        AbstractCompile _javaCompiler = variant.getJavaCompiler();
        final Action<Task> _function_1 = new Action<Task>() {
          @Override
          public void execute(final Task it) {
            generatorTask.installDebugInfo();
          }
        };
        _javaCompiler.doLast(_function_1);
        final ArrayList<File> sourceDirs = CollectionLiterals.<File>newArrayList();
        List<SourceProvider> _sourceSets = variant.getSourceSets();
        final Function1<SourceProvider, Collection<File>> _function_2 = new Function1<SourceProvider, Collection<File>>() {
          @Override
          public Collection<File> apply(final SourceProvider it) {
            return it.getJavaDirectories();
          }
        };
        List<Collection<File>> _map_1 = ListExtensions.<SourceProvider, Collection<File>>map(_sourceSets, _function_2);
        Iterable<File> _flatten = Iterables.<File>concat(_map_1);
        final Function1<File, Boolean> _function_3 = new Function1<File, Boolean>() {
          @Override
          public Boolean apply(final File it) {
            return Boolean.valueOf(it.isDirectory());
          }
        };
        final Iterable<File> javaDirs = IterableExtensions.<File>filter(_flatten, _function_3);
        Iterables.<File>addAll(sourceDirs, javaDirs);
        AidlCompile _aidlCompile_1 = variant.getAidlCompile();
        File _sourceOutputDir = _aidlCompile_1.getSourceOutputDir();
        GenerateBuildConfig _generateBuildConfig_1 = variant.getGenerateBuildConfig();
        File _sourceOutputDir_1 = _generateBuildConfig_1.getSourceOutputDir();
        RenderscriptCompile _renderscriptCompile_1 = variant.getRenderscriptCompile();
        File _sourceOutputDir_2 = _renderscriptCompile_1.getSourceOutputDir();
        Iterables.<File>addAll(sourceDirs, Collections.<File>unmodifiableList(CollectionLiterals.<File>newArrayList(_sourceOutputDir, _sourceOutputDir_1, _sourceOutputDir_2)));
        List<BaseVariantOutput> _outputs_1 = variant.getOutputs();
        final Function1<BaseVariantOutput, File> _function_4 = new Function1<BaseVariantOutput, File>() {
          @Override
          public File apply(final BaseVariantOutput it) {
            ProcessAndroidResources _processResources = it.getProcessResources();
            return _processResources.getSourceOutputDir();
          }
        };
        List<File> _map_2 = ListExtensions.<BaseVariantOutput, File>map(_outputs_1, _function_4);
        Iterables.<File>addAll(sourceDirs, _map_2);
        sourceSet.srcDirs(sourceDirs);
        List<File> _bootClasspath = XtextAndroidBuilderPlugin.this.android.getBootClasspath();
        String _join = IterableExtensions.join(_bootClasspath, File.pathSeparator);
        generatorTask.setBootClasspath(_join);
        AbstractCompile _javaCompiler_1 = variant.getJavaCompiler();
        FileCollection _classpath = _javaCompiler_1.getClasspath();
        List<File> _bootClasspath_1 = XtextAndroidBuilderPlugin.this.android.getBootClasspath();
        ConfigurableFileCollection _files = XtextAndroidBuilderPlugin.this.project.files(_bootClasspath_1);
        FileCollection _plus = _classpath.plus(_files);
        generatorTask.setClasspath(_plus);
        AbstractCompile _javaCompiler_2 = variant.getJavaCompiler();
        File _destinationDir = _javaCompiler_2.getDestinationDir();
        generatorTask.setClassesDir(_destinationDir);
        XtextBuilderOptions _options = generatorTask.getOptions();
        CompileOptions _compileOptions = XtextAndroidBuilderPlugin.this.android.getCompileOptions();
        String _encoding = _compileOptions.getEncoding();
        _options.setEncoding(_encoding);
        FileCollection _outputDirectories = generatorTask.getOutputDirectories();
        variant.registerJavaGeneratingTask(generatorTask, ((File[])Conversions.unwrapArray(_outputDirectories, File.class)));
      }
    };
    return ObjectExtensions.<XtextSourceDirectorySet>operator_doubleArrow(_maybeCreate, _function);
  }
  
  private void configureGeneratorDefaults() {
    NamedDomainObjectContainer<Language> _languages = this.xtext.getLanguages();
    final Action<Language> _function = new Action<Language>() {
      @Override
      public void execute(final Language it) {
        GeneratorConfig _generator = it.getGenerator();
        CompileOptions _compileOptions = XtextAndroidBuilderPlugin.this.android.getCompileOptions();
        JavaVersion _sourceCompatibility = _compileOptions.getSourceCompatibility();
        String _string = _sourceCompatibility.toString();
        _generator.setJavaSourceLevel(_string);
      }
    };
    _languages.all(_function);
  }
  
  private void configureOutletDefaults() {
    NamedDomainObjectContainer<Language> _languages = this.xtext.getLanguages();
    final Action<Language> _function = new Action<Language>() {
      @Override
      public void execute(final Language language) {
        GeneratorConfig _generator = language.getGenerator();
        NamedDomainObjectContainer<Outlet> _outlets = _generator.getOutlets();
        final Action<Outlet> _function = new Action<Outlet>() {
          @Override
          public void execute(final Outlet outlet) {
            NamedDomainObjectContainer<XtextSourceDirectorySet> _sourceSets = XtextAndroidBuilderPlugin.this.xtext.getSourceSets();
            final Action<XtextSourceDirectorySet> _function = new Action<XtextSourceDirectorySet>() {
              @Override
              public void execute(final XtextSourceDirectorySet sourceSet) {
                final XtextSourceSetOutputs output = sourceSet.getOutput();
                StringConcatenation _builder = new StringConcatenation();
                File _buildDir = XtextAndroidBuilderPlugin.this.project.getBuildDir();
                _builder.append(_buildDir, "");
                _builder.append("/generated/source/");
                String _name = language.getName();
                _builder.append(_name, "");
                String _folderFragment = outlet.getFolderFragment();
                _builder.append(_folderFragment, "");
                _builder.append("/");
                String _name_1 = sourceSet.getName();
                _builder.append(_name_1, "");
                output.dir(outlet, _builder);
              }
            };
            _sourceSets.all(_function);
          }
        };
        _outlets.all(_function);
      }
    };
    _languages.all(_function);
  }
}
