/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.qa.benchmark;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.common.LoadExecutor;
import org.xipki.common.util.ParamUtil;
import org.xipki.ocsp.client.api.OcspRequestorException;
import org.xipki.ocsp.client.api.RequestOptions;
import org.xipki.ocsp.qa.benchmark.OcspBenchRequestor;

public class OcspBenchmark
extends LoadExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(OcspBenchmark.class);
    private final Certificate issuerCert;
    private final String responderUrl;
    private final RequestOptions requestOptions;
    private final Iterator<BigInteger> serials;
    private final int maxRequests;
    private final boolean parseResponse;
    private final int queueSize;
    private AtomicInteger processedRequests = new AtomicInteger(0);

    public OcspBenchmark(Certificate issuerCert, String responderUrl, RequestOptions requestOptions, Iterator<BigInteger> serials, int maxRequests, boolean parseResponse, int queueSize, String description) {
        super(description);
        this.issuerCert = (Certificate)ParamUtil.requireNonNull((String)"issuerCert", (Object)issuerCert);
        this.responderUrl = (String)ParamUtil.requireNonNull((String)"responderUrl", (Object)responderUrl);
        this.requestOptions = (RequestOptions)ParamUtil.requireNonNull((String)"requestOptions", (Object)requestOptions);
        this.maxRequests = maxRequests;
        this.serials = (Iterator)ParamUtil.requireNonNull((String)"serials", serials);
        this.parseResponse = parseResponse;
        this.queueSize = queueSize;
    }

    protected Runnable getTestor() throws Exception {
        return new Testor();
    }

    private BigInteger nextSerialNumber() {
        int num;
        if (this.maxRequests > 0 && (num = this.processedRequests.getAndAdd(1)) >= this.maxRequests) {
            return null;
        }
        try {
            return this.serials.next();
        }
        catch (NoSuchElementException ex) {
            return null;
        }
    }

    public void onComplete(FullHttpResponse response) {
        boolean success;
        try {
            success = this.onComplete0(response);
        }
        catch (Throwable th) {
            LOG.warn("unexpected exception", th);
            success = false;
        }
        this.account(1, success ? 0 : 1);
    }

    public synchronized void onError() {
        this.account(1, 1);
    }

    private boolean onComplete0(FullHttpResponse response) {
        Object respObject;
        OCSPResp ocspResp;
        if (response == null) {
            LOG.warn("bad response: response is null");
            return false;
        }
        if (response.decoderResult().isFailure()) {
            LOG.warn("failed: {}", (Object)response.decoderResult());
            return false;
        }
        if (response.status().code() != HttpResponseStatus.OK.code()) {
            LOG.warn("bad response: {}", (Object)response.status());
            return false;
        }
        String responseContentType = response.headers().get("Content-Type");
        if (responseContentType == null) {
            LOG.warn("bad response: mandatory Content-Type not specified");
            return false;
        }
        if (!responseContentType.equalsIgnoreCase("application/ocsp-response")) {
            LOG.warn("bad response: Content-Type {} unsupported", (Object)responseContentType);
            return false;
        }
        ByteBuf buf = response.content();
        if (buf == null || buf.readableBytes() == 0) {
            LOG.warn("no body in response");
            return false;
        }
        byte[] respBytes = new byte[buf.readableBytes()];
        buf.getBytes(buf.readerIndex(), respBytes);
        if (!this.parseResponse) {
            if (respBytes.length < 10) {
                LOG.warn("bad response: response too short");
                return false;
            }
            return true;
        }
        try {
            ocspResp = new OCSPResp(respBytes);
        }
        catch (IOException ex) {
            LOG.warn("could not parse OCSP response", (Throwable)ex);
            return false;
        }
        try {
            respObject = ocspResp.getResponseObject();
        }
        catch (OCSPException ex) {
            LOG.warn("responseObject is invalid", (Throwable)ex);
            return false;
        }
        if (ocspResp.getStatus() != 0) {
            LOG.warn("bad response: response status is other than OK");
            return false;
        }
        if (!(respObject instanceof BasicOCSPResp)) {
            LOG.warn("bad response: response is not BasiOCSPResp");
            return false;
        }
        return true;
    }

    final class Testor
    implements Runnable {
        private OcspBenchRequestor requestor = new OcspBenchRequestor();

        Testor() throws Exception {
            this.requestor.init(OcspBenchmark.this, OcspBenchmark.this.responderUrl, OcspBenchmark.this.issuerCert, OcspBenchmark.this.requestOptions, OcspBenchmark.this.queueSize);
        }

        @Override
        public void run() {
            BigInteger sn;
            while (!OcspBenchmark.this.stop() && (sn = OcspBenchmark.this.nextSerialNumber()) != null) {
                this.testNext(sn);
            }
            try {
                this.requestor.shutdown();
            }
            catch (Exception ex) {
                LOG.warn("got IOException in requestor.stop()");
            }
        }

        private void testNext(BigInteger sn) {
            try {
                this.requestor.ask(new BigInteger[]{sn});
            }
            catch (OcspRequestorException ex) {
                LOG.warn("OCSPRequestorException: {}", (Object)ex.getMessage());
                OcspBenchmark.this.account(1, 1);
            }
            catch (Throwable th) {
                LOG.warn("{}: {}", (Object)th.getClass().getName(), (Object)th.getMessage());
                OcspBenchmark.this.account(1, 1);
            }
        }
    }
}

