/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.qa.benchmark;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.ocsp.CertID;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.xipki.common.util.Base64;
import org.xipki.common.util.ParamUtil;
import org.xipki.ocsp.client.api.OcspRequestorException;
import org.xipki.ocsp.client.api.RequestOptions;
import org.xipki.ocsp.qa.benchmark.HttpClient;
import org.xipki.ocsp.qa.benchmark.OcspBenchmark;
import org.xipki.security.HashAlgoType;
import org.xipki.security.ObjectIdentifiers;

class OcspBenchRequestor {
    public static final int MAX_LEN_GET = 190;
    private final Extension[] extnType = new Extension[0];
    private final SecureRandom random = new SecureRandom();
    private static final ConcurrentHashMap<BigInteger, byte[]> requests = new ConcurrentHashMap();
    private AlgorithmIdentifier issuerhashAlg;
    private ASN1OctetString issuerNameHash;
    private ASN1OctetString issuerKeyHash;
    private Extension[] extensions;
    private RequestOptions requestOptions;
    private String responderRawPathPost;
    private String responderRawPathGet;
    private HttpClient httpClient;

    OcspBenchRequestor() {
    }

    public void init(OcspBenchmark responseHandler, String responderUrl, Certificate issuerCert, RequestOptions requestOptions, int queueSize) throws Exception {
        ParamUtil.requireNonNull((String)"issuerCert", (Object)issuerCert);
        ParamUtil.requireNonNull((String)"responseHandler", (Object)((Object)responseHandler));
        this.requestOptions = (RequestOptions)ParamUtil.requireNonNull((String)"requestOptions", (Object)requestOptions);
        HashAlgoType hashAlgo = HashAlgoType.getHashAlgoType((ASN1ObjectIdentifier)requestOptions.hashAlgorithmId());
        if (hashAlgo == null) {
            throw new OcspRequestorException("unknown HashAlgo " + requestOptions.hashAlgorithmId().getId());
        }
        this.issuerhashAlg = hashAlgo.algorithmIdentifier();
        this.issuerNameHash = new DEROctetString(hashAlgo.hash(issuerCert.getSubject().getEncoded()));
        this.issuerKeyHash = new DEROctetString(hashAlgo.hash(issuerCert.getSubjectPublicKeyInfo().getPublicKeyData().getOctets()));
        List prefSigAlgs = requestOptions.preferredSignatureAlgorithms();
        if (prefSigAlgs == null || prefSigAlgs.size() == 0) {
            this.extensions = null;
        } else {
            Extension extn;
            ASN1EncodableVector vec = new ASN1EncodableVector();
            for (AlgorithmIdentifier algId : prefSigAlgs) {
                DERSequence prefSigAlgObj = new DERSequence((ASN1Encodable)algId);
                vec.add((ASN1Encodable)prefSigAlgObj);
            }
            DERSequence extnValue = new DERSequence(vec);
            try {
                extn = new Extension(ObjectIdentifiers.id_pkix_ocsp_prefSigAlgs, false, (ASN1OctetString)new DEROctetString((ASN1Encodable)extnValue));
            }
            catch (IOException ex) {
                throw new OcspRequestorException(ex.getMessage(), (Throwable)ex);
            }
            this.extensions = new Extension[]{extn};
        }
        URI uri = new URI(responderUrl);
        this.responderRawPathPost = uri.getRawPath();
        this.responderRawPathGet = this.responderRawPathPost.endsWith("/") ? this.responderRawPathPost : this.responderRawPathPost + "/";
        this.httpClient = new HttpClient(responderUrl, responseHandler, queueSize);
        this.httpClient.start();
    }

    public void shutdown() throws Exception {
        this.httpClient.shutdown();
    }

    public void ask(BigInteger[] serialNumbers) throws OcspRequestorException {
        DefaultFullHttpRequest request;
        byte[] ocspReq = this.buildRequest(serialNumbers);
        int size = ocspReq.length;
        if (size <= 190 && this.requestOptions.isUseHttpGetForRequest()) {
            String urlEncodedReq;
            String b64Request = Base64.encodeToString((byte[])ocspReq);
            try {
                urlEncodedReq = URLEncoder.encode(b64Request, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new OcspRequestorException(ex.getMessage());
            }
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append(this.responderRawPathGet);
            urlBuilder.append(urlEncodedReq);
            String newRawpath = urlBuilder.toString();
            request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, newRawpath);
        } else {
            ByteBuf content = Unpooled.wrappedBuffer((byte[])ocspReq);
            request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, this.responderRawPathPost, content);
            request.headers().addInt((CharSequence)"Content-Length", content.readableBytes());
        }
        request.headers().add("Content-Type", (Object)"application/ocsp-request");
        this.httpClient.send((FullHttpRequest)request);
    }

    private byte[] buildRequest(BigInteger[] serialNumbers) throws OcspRequestorException {
        byte[] request;
        boolean canCache;
        boolean bl = canCache = serialNumbers.length == 1 && !this.requestOptions.isUseNonce();
        if (canCache && (request = requests.get(serialNumbers[0])) != null) {
            return request;
        }
        OCSPReqBuilder reqBuilder = new OCSPReqBuilder();
        if (this.requestOptions.isUseNonce() || this.extensions != null) {
            BigInteger[] extns = new ArrayList(2);
            if (this.requestOptions.isUseNonce()) {
                Extension extn = new Extension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, false, (ASN1OctetString)new DEROctetString(this.nextNonce(this.requestOptions.nonceLen())));
                extns.add(extn);
            }
            if (this.extensions != null) {
                Extension[] extensionArray = this.extensions;
                int n = extensionArray.length;
                for (int i = 0; i < n; ++i) {
                    Extension extn = extensionArray[i];
                    extns.add(extn);
                }
            }
            reqBuilder.setRequestExtensions(new Extensions(extns.toArray(this.extnType)));
        }
        try {
            for (BigInteger serialNumber : serialNumbers) {
                CertID certId = new CertID(this.issuerhashAlg, this.issuerNameHash, this.issuerKeyHash, new ASN1Integer(serialNumber));
                reqBuilder.addRequest(new CertificateID(certId));
            }
            byte[] request2 = reqBuilder.build().getEncoded();
            if (canCache) {
                requests.put(serialNumbers[0], request2);
            }
            return request2;
        }
        catch (IOException | OCSPException ex) {
            throw new OcspRequestorException(ex.getMessage(), ex);
        }
    }

    private byte[] nextNonce(int nonceLen) {
        byte[] nonce = new byte[nonceLen];
        this.random.nextBytes(nonce);
        return nonce;
    }
}

