/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.qa.benchmark;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.common.concurrent.CountLatch;
import org.xipki.common.util.ParamUtil;
import org.xipki.ocsp.client.api.OcspRequestorException;
import org.xipki.ocsp.qa.benchmark.OcspBenchmark;

final class HttpClient {
    private static final Logger LOG;
    private static Boolean epollAvailable;
    private static Boolean kqueueAvailable;
    private final CountLatch latch = new CountLatch(0L, 0L);
    private int queueSize = 1000;
    private String uri;
    private OcspBenchmark responseHandler;
    private EventLoopGroup workerGroup;
    private Channel channel;
    private int pendingRequests = 0;

    public HttpClient(String uri, OcspBenchmark responseHandler, int queueSize) {
        this.uri = (String)ParamUtil.requireNonNull((String)"uri", (Object)uri);
        if (queueSize > 0) {
            this.queueSize = queueSize;
        }
        this.responseHandler = (OcspBenchmark)((Object)ParamUtil.requireNonNull((String)"responseHandler", (Object)((Object)responseHandler)));
        this.workerGroup = new NioEventLoopGroup(1);
    }

    public void start() throws Exception {
        Class<?> clazz;
        URI uri = new URI(this.uri);
        String scheme = uri.getScheme() == null ? "http" : uri.getScheme();
        String host = uri.getHost() == null ? "127.0.0.1" : uri.getHost();
        int port = uri.getPort();
        if (port == -1 && "http".equalsIgnoreCase(scheme)) {
            port = 80;
        }
        if (!"http".equalsIgnoreCase(scheme)) {
            System.err.println("Only HTTP is supported.");
            return;
        }
        Class channelClass = NioSocketChannel.class;
        boolean numThreads = true;
        ClassLoader loader = this.getClass().getClassLoader();
        if (epollAvailable != null && epollAvailable.booleanValue()) {
            try {
                channelClass = Class.forName("io.netty.channel.epoll.EpollSocketChannel", false, loader);
                clazz = Class.forName("io.netty.channel.epoll.EpollEventLoopGroup", true, loader);
                Constructor<?> constructor = clazz.getConstructor(Integer.TYPE);
                this.workerGroup = (EventLoopGroup)constructor.newInstance(1);
                LOG.info("use Epoll Transport");
            }
            catch (Throwable th) {
                if (th instanceof ClassNotFoundException) {
                    LOG.info("epoll linux is not in classpath");
                } else {
                    LOG.warn("could not use Epoll transport: {}", (Object)th.getMessage());
                    LOG.debug("could not use Epoll transport", th);
                }
                channelClass = null;
                this.workerGroup = null;
            }
        } else if (kqueueAvailable != null && kqueueAvailable.booleanValue()) {
            try {
                channelClass = Class.forName("io.netty.channel.kqueue.KQueueSocketChannel", false, loader);
                clazz = Class.forName("io.netty.channel.kqueue.KQueueEventLoopGroup", true, loader);
                Constructor<?> constructor = clazz.getConstructor(Integer.TYPE);
                this.workerGroup = (EventLoopGroup)constructor.newInstance(1);
                LOG.info("Use KQueue Transport");
            }
            catch (Exception ex) {
                LOG.warn("could not use KQueue transport: {}", (Object)ex.getMessage());
                LOG.debug("could not use KQueue transport", (Throwable)ex);
                channelClass = null;
                this.workerGroup = null;
            }
        }
        if (this.workerGroup == null) {
            channelClass = NioSocketChannel.class;
            this.workerGroup = new NioEventLoopGroup(1);
        }
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(this.workerGroup)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)60000)).channel(channelClass)).handler((ChannelHandler)new HttpClientInitializer());
        this.channel = bootstrap.connect(host, port).syncUninterruptibly().channel();
    }

    public void send(FullHttpRequest request) throws OcspRequestorException {
        if (!this.channel.isActive()) {
            throw new OcspRequestorException("channel is not active");
        }
        try {
            this.latch.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            throw new OcspRequestorException("sending poll is full");
        }
        this.incrementPendingRequests();
        ChannelFuture future = this.channel.writeAndFlush((Object)request);
        future.awaitUninterruptibly();
    }

    public void shutdown() {
        if (this.channel != null) {
            this.channel = null;
        }
        this.workerGroup.shutdownGracefully();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementPendingRequests() {
        CountLatch countLatch = this.latch;
        synchronized (countLatch) {
            if (++this.pendingRequests >= this.queueSize && this.latch.getCount() == 0L) {
                this.latch.countUp();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementPendingRequests() {
        CountLatch countLatch = this.latch;
        synchronized (countLatch) {
            if (--this.pendingRequests < this.queueSize) {
                int count = (int)this.latch.getCount();
                if (count > 0) {
                    while (this.latch.getCount() != 0L) {
                        this.latch.countDown();
                    }
                } else if (count < 0) {
                    while (this.latch.getCount() != 0L) {
                        this.latch.countUp();
                    }
                }
            }
        }
    }

    static {
        block10: {
            LOG = LoggerFactory.getLogger(HttpClient.class);
            String os = System.getProperty("os.name").toLowerCase();
            ClassLoader loader = HttpClient.class.getClassLoader();
            if (os.contains("linux")) {
                try {
                    Class<?> checkClazz = Class.forName("io.netty.channel.epoll.Epoll", false, loader);
                    Method mt = checkClazz.getMethod("isAvailable", new Class[0]);
                    Object obj = mt.invoke(null, new Object[0]);
                    if (obj instanceof Boolean) {
                        epollAvailable = (Boolean)obj;
                    }
                }
                catch (Throwable th) {
                    if (th instanceof ClassNotFoundException) {
                        LOG.info("epoll linux is not in classpath");
                        break block10;
                    }
                    LOG.warn("could not use Epoll transport: {}", (Object)th.getMessage());
                    LOG.debug("could not use Epoll transport", th);
                }
            } else if (os.contains("mac os") || os.contains("os x")) {
                try {
                    Class<?> checkClazz = Class.forName("io.netty.channel.epoll.kqueue.KQueue", false, loader);
                    Method mt = checkClazz.getMethod("isAvailable", new Class[0]);
                    Object obj = mt.invoke(null, new Object[0]);
                    if (obj instanceof Boolean) {
                        kqueueAvailable = (Boolean)obj;
                    }
                }
                catch (Exception ex) {
                    LOG.warn("could not use KQueue transport: {}", (Object)ex.getMessage());
                    LOG.debug("could not use KQueue transport", (Throwable)ex);
                }
            }
        }
    }

    private class HttpClientHandler
    extends SimpleChannelInboundHandler<FullHttpResponse> {
        private HttpClientHandler() {
        }

        public void channelRead0(ChannelHandlerContext ctx, FullHttpResponse resp) {
            try {
                HttpClient.this.decrementPendingRequests();
                HttpClient.this.responseHandler.onComplete(resp);
            }
            catch (Throwable th) {
                LOG.error("unexpected error", th);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            HttpClient.this.decrementPendingRequests();
            ctx.close();
            LOG.warn("error", cause);
            HttpClient.this.responseHandler.onError();
        }
    }

    private class HttpClientInitializer
    extends ChannelInitializer<SocketChannel> {
        public void initChannel(SocketChannel ch) {
            ChannelPipeline pipeline = ch.pipeline();
            pipeline.addLast(new ChannelHandler[]{new ReadTimeoutHandler(60L, TimeUnit.SECONDS)}).addLast(new ChannelHandler[]{new WriteTimeoutHandler(60L, TimeUnit.SECONDS)}).addLast(new ChannelHandler[]{new HttpClientCodec()}).addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)}).addLast(new ChannelHandler[]{new HttpClientHandler()});
        }
    }
}

