/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.qa;

import org.xipki.common.util.ParamUtil;

public enum OcspError {
    malformedRequest(1),
    internalError(2),
    tryLater(3),
    sigRequired(4),
    unauthorized(5);

    private final int status;

    private OcspError(int status) {
        this.status = status;
    }

    public int status() {
        return this.status;
    }

    public static OcspError forName(String name) {
        ParamUtil.requireNonNull((String)"name", (Object)name);
        for (OcspError entry : OcspError.values()) {
            if (!entry.name().equals(name)) continue;
            return entry;
        }
        throw new IllegalArgumentException("unknown OCSP error '" + name + "'");
    }

    public static OcspError forCode(int status) {
        for (OcspError entry : OcspError.values()) {
            if (entry.status != status) continue;
            return entry;
        }
        throw new IllegalArgumentException("unknown OCSP error code '" + status + "'");
    }
}

