/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.client.shell.loadtest;

import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.bouncycastle.asn1.x509.Certificate;
import org.xipki.common.util.Base64;
import org.xipki.common.util.ParamUtil;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.datasource.springframework.dao.DataAccessException;

class DbGoodCertSerialIterator
implements Iterator<BigInteger> {
    private static final int numSqlEntries = 1000;
    private final String sqlNextSerials;
    private final DataSourceWrapper caDataSource;
    private final BigInteger caSerial;
    private final ConcurrentLinkedDeque<BigInteger> nextSerials = new ConcurrentLinkedDeque();
    private final int caId;
    private final long minId;
    private long nextStartId;
    private boolean noUnrevokedCerts;
    private BigInteger currentSerial;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbGoodCertSerialIterator(Certificate caCert, DataSourceWrapper caDataSource) throws Exception {
        ParamUtil.requireNonNull((String)"caCert", (Object)caCert);
        this.caDataSource = (DataSourceWrapper)ParamUtil.requireNonNull((String)"caDataSource", (Object)caDataSource);
        this.caSerial = caCert.getSerialNumber().getPositiveValue();
        this.sqlNextSerials = caDataSource.buildSelectFirstSql(1000, "ID", "ID,SN FROM CERT WHERE REV=0 AND CA_ID=? AND ID>=?");
        byte[] encodedCaCert = caCert.getEncoded();
        String sql = "SELECT ID,CERT FROM CA";
        Statement stmt = caDataSource.getConnection().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(sql);
            int tmpCaId = -1;
            while (rs.next()) {
                String b64DbCert = rs.getString("CERT");
                byte[] dbCert = Base64.decodeFast((String)b64DbCert);
                if (!Arrays.equals(encodedCaCert, dbCert)) continue;
                tmpCaId = rs.getInt("ID");
                break;
            }
            rs.close();
            if (tmpCaId == -1) {
                throw new Exception("CA Certificate and database configuration does not match");
            }
            this.caId = tmpCaId;
            sql = "SELECT MIN(ID) FROM CERT WHERE REV=0 AND CA_ID=" + this.caId;
            rs = stmt.executeQuery(sql);
            rs.next();
            this.nextStartId = this.minId = rs.getLong(1);
        }
        finally {
            caDataSource.releaseResources(stmt, null);
        }
        this.currentSerial = this.readNextNumber();
    }

    @Override
    public boolean hasNext() {
        return this.currentSerial != null;
    }

    @Override
    public synchronized BigInteger next() {
        BigInteger ret = this.currentSerial;
        this.currentSerial = this.readNextNumber();
        return ret;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BigInteger readNextNumber() {
        BigInteger firstSerial = this.nextSerials.pollFirst();
        if (firstSerial != null) {
            return firstSerial;
        }
        if (this.noUnrevokedCerts) {
            return null;
        }
        String sql = this.sqlNextSerials;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int idx = 0;
        try {
            stmt = this.caDataSource.getConnection().prepareStatement(sql);
            stmt.setInt(1, this.caId);
            stmt.setLong(2, this.nextStartId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String serialStr;
                BigInteger serial;
                ++idx;
                long id = rs.getLong("ID");
                if (id + 1L > this.nextStartId) {
                    this.nextStartId = id + 1L;
                }
                if (this.caSerial.equals(serial = new BigInteger(serialStr = rs.getString("SN"), 16))) continue;
                this.nextSerials.addLast(serial);
            }
        }
        catch (SQLException ex) {
            try {
                DataAccessException daex = this.caDataSource.translate(sql, ex);
                throw new NoSuchElementException(daex.getMessage());
                catch (DataAccessException ex2) {
                    throw new NoSuchElementException(ex2.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.caDataSource.releaseResources((Statement)stmt, rs);
                throw throwable;
            }
        }
        this.caDataSource.releaseResources((Statement)stmt, rs);
        if (idx < 1000) {
            this.noUnrevokedCerts = true;
        }
        return this.nextSerials.pollFirst();
    }
}

