/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.client.shell.loadtest;

import java.io.FileInputStream;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.ca.client.shell.loadtest.CaLoadTestCommandSupport;
import org.xipki.ca.client.shell.loadtest.CaLoadTestTemplateEnroll;
import org.xipki.ca.client.shell.loadtest.jaxb.EnrollTemplateType;
import org.xipki.console.karaf.IllegalCmdParamException;
import org.xipki.console.karaf.completer.FilePathCompleter;

@Command(scope="xipki-cli", name="benchmark-template-enroll", description="CA client template enroll load test")
@Service
public class CaLoadTestTemplateEnrollCmd
extends CaLoadTestCommandSupport {
    @Option(name="--template", aliases={"-t"}, required=true, description="template file. Note the contained profiles must allow duplication of public key \n(required)")
    @Completion(value=FilePathCompleter.class)
    private String templateFile;
    @Option(name="--duration", description="duration")
    private String duration = "30s";
    @Option(name="--thread", description="number of threads")
    private Integer numThreads = 5;
    @Option(name="--max-num", description="maximal number of requests\n0 for unlimited")
    private Integer maxRequests = 0;

    protected Object execute0() throws Exception {
        if (this.numThreads < 1) {
            throw new IllegalCmdParamException("invalid number of threads " + this.numThreads);
        }
        EnrollTemplateType template = CaLoadTestTemplateEnroll.parse(new FileInputStream(this.templateFile));
        int size = template.getEnrollCert().size();
        StringBuilder description = new StringBuilder(200);
        description.append("template: ").append(this.templateFile).append("\n");
        description.append("maxRequests: ").append(this.maxRequests).append("\n");
        description.append("unit: ").append(size).append(" certificate");
        if (size > 1) {
            description.append("s");
        }
        description.append("\n");
        CaLoadTestTemplateEnroll loadTest = new CaLoadTestTemplateEnroll(this.caClient, template, this.maxRequests, description.toString());
        loadTest.setDuration(this.duration);
        loadTest.setThreads(this.numThreads);
        loadTest.test();
        return null;
    }
}

