/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.client.shell.loadtest;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.SchemaFactory;
import org.bouncycastle.asn1.crmf.CertRequest;
import org.bouncycastle.asn1.crmf.CertTemplate;
import org.bouncycastle.asn1.crmf.CertTemplateBuilder;
import org.bouncycastle.asn1.crmf.ProofOfPossession;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.client.api.CaClient;
import org.xipki.ca.client.api.CaClientException;
import org.xipki.ca.client.api.CertOrError;
import org.xipki.ca.client.api.EnrollCertResult;
import org.xipki.ca.client.api.PkiErrorException;
import org.xipki.ca.client.api.dto.EnrollCertRequest;
import org.xipki.ca.client.api.dto.EnrollCertRequestEntry;
import org.xipki.ca.client.shell.loadtest.KeyEntry;
import org.xipki.ca.client.shell.loadtest.LoadTestEntry;
import org.xipki.ca.client.shell.loadtest.jaxb.EnrollCertType;
import org.xipki.ca.client.shell.loadtest.jaxb.EnrollTemplateType;
import org.xipki.ca.client.shell.loadtest.jaxb.ObjectFactory;
import org.xipki.common.InvalidConfException;
import org.xipki.common.LoadExecutor;
import org.xipki.common.util.ParamUtil;
import org.xipki.common.util.XmlUtil;
import org.xml.sax.SAXException;

public class CaLoadTestTemplateEnroll
extends LoadExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(CaLoadTestTemplateEnroll.class);
    private static final ProofOfPossession RA_VERIFIED = new ProofOfPossession();
    private static Object jaxbUnmarshallerLock = new Object();
    private static Unmarshaller jaxbUnmarshaller;
    private final CaClient caClient;
    private final List<LoadTestEntry> loadtestEntries;
    private final int maxRequests;
    private AtomicInteger processedRequests = new AtomicInteger(0);
    private final AtomicLong index;

    public CaLoadTestTemplateEnroll(CaClient caClient, EnrollTemplateType template, int maxRequests, String description) throws Exception {
        super(description);
        ParamUtil.requireNonNull((String)"template", (Object)template);
        this.maxRequests = maxRequests;
        this.caClient = (CaClient)ParamUtil.requireNonNull((String)"caClient", (Object)caClient);
        Calendar baseTime = Calendar.getInstance(Locale.UK);
        baseTime.set(1, 2014);
        baseTime.set(2, 0);
        baseTime.set(5, 1);
        this.index = new AtomicLong(CaLoadTestTemplateEnroll.getSecureIndex());
        List<EnrollCertType> list = template.getEnrollCert();
        this.loadtestEntries = new ArrayList<LoadTestEntry>(list.size());
        for (EnrollCertType entry : list) {
            KeyEntry keyEntry;
            if (entry.getEcKey() != null) {
                keyEntry = new KeyEntry.ECKeyEntry(entry.getEcKey().getCurve());
            } else if (entry.getRsaKey() != null) {
                keyEntry = new KeyEntry.RSAKeyEntry(entry.getRsaKey().getModulusLength());
            } else if (entry.getDsaKey() != null) {
                keyEntry = new KeyEntry.DSAKeyEntry(entry.getDsaKey().getPLength());
            } else {
                throw new RuntimeException("should not reach here, unknown child of KeyEntry");
            }
            String randomDnStr = entry.getRandomDN();
            LoadTestEntry.RandomDn randomDn = LoadTestEntry.RandomDn.getInstance(randomDnStr);
            if (randomDn == null) {
                throw new InvalidConfException("invalid randomDN " + randomDnStr);
            }
            LoadTestEntry loadtestEntry = new LoadTestEntry(entry.getCertprofile(), keyEntry, entry.getSubject(), randomDn);
            this.loadtestEntries.add(loadtestEntry);
        }
    }

    protected Runnable getTestor() throws Exception {
        return new Testor();
    }

    public int getNumberOfCertsInOneRequest() {
        return this.loadtestEntries.size();
    }

    private Map<Integer, CertRequestWithProfile> nextCertRequests() {
        int num;
        if (this.maxRequests > 0 && (num = this.processedRequests.getAndAdd(1)) >= this.maxRequests) {
            return null;
        }
        HashMap<Integer, CertRequestWithProfile> certRequests = new HashMap<Integer, CertRequestWithProfile>();
        int n = this.loadtestEntries.size();
        for (int i = 0; i < n; ++i) {
            LoadTestEntry loadtestEntry = this.loadtestEntries.get(i);
            int certId = i + 1;
            CertTemplateBuilder certTempBuilder = new CertTemplateBuilder();
            long thisIndex = this.index.getAndIncrement();
            certTempBuilder.setSubject(loadtestEntry.getX500Name(thisIndex));
            SubjectPublicKeyInfo spki = loadtestEntry.getSubjectPublicKeyInfo();
            certTempBuilder.setPublicKey(spki);
            CertTemplate certTemplate = certTempBuilder.build();
            CertRequest certRequest = new CertRequest(certId, certTemplate, null);
            CertRequestWithProfile requestWithCertprofile = new CertRequestWithProfile(loadtestEntry.certprofile(), certRequest);
            certRequests.put(certId, requestWithCertprofile);
        }
        return certRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EnrollTemplateType parse(InputStream configStream) throws InvalidConfException {
        Object root;
        ParamUtil.requireNonNull((String)"configStream", (Object)configStream);
        Object object = jaxbUnmarshallerLock;
        synchronized (object) {
            try {
                if (jaxbUnmarshaller == null) {
                    JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
                    jaxbUnmarshaller = context.createUnmarshaller();
                    SchemaFactory schemaFact = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                    URL url = ObjectFactory.class.getResource("/xsd/loadtest.xsd");
                    jaxbUnmarshaller.setSchema(schemaFact.newSchema(url));
                }
                root = jaxbUnmarshaller.unmarshal(configStream);
            }
            catch (SAXException ex) {
                throw new InvalidConfException("parsing profile failed, message: " + ex.getMessage(), (Throwable)ex);
            }
            catch (JAXBException ex) {
                throw new InvalidConfException("parsing profile failed, message: " + XmlUtil.getMessage((JAXBException)ex), (Throwable)ex);
            }
        }
        try {
            configStream.close();
        }
        catch (IOException ex) {
            LOG.warn("could not close xmlConfStream: {}", (Object)ex.getMessage());
        }
        if (root instanceof JAXBElement) {
            return (EnrollTemplateType)((JAXBElement)root).getValue();
        }
        throw new InvalidConfException("invalid root element type");
    }

    class Testor
    implements Runnable {
        Testor() {
        }

        @Override
        public void run() {
            Map certReqs;
            while (!CaLoadTestTemplateEnroll.this.stop() && CaLoadTestTemplateEnroll.this.getErrorAccout() < 1L && (certReqs = CaLoadTestTemplateEnroll.this.nextCertRequests()) != null) {
                boolean successful = this.testNext(certReqs);
                int numFailed = successful ? 0 : 1;
                CaLoadTestTemplateEnroll.this.account(1, numFailed);
            }
        }

        private boolean testNext(Map<Integer, CertRequestWithProfile> certRequests) {
            EnrollCertResult result;
            try {
                EnrollCertRequest request = new EnrollCertRequest(EnrollCertRequest.Type.CERT_REQ);
                for (Integer certId : certRequests.keySet()) {
                    CertRequestWithProfile certRequest = certRequests.get(certId);
                    EnrollCertRequestEntry requestEntry = new EnrollCertRequestEntry("id-" + certId, certRequest.certprofile, certRequest.certRequest, RA_VERIFIED);
                    request.addRequestEntry(requestEntry);
                }
                result = CaLoadTestTemplateEnroll.this.caClient.requestCerts(null, request, null);
            }
            catch (CaClientException | PkiErrorException ex) {
                LOG.warn("{}: {}", (Object)ex.getClass().getName(), (Object)ex.getMessage());
                return false;
            }
            catch (Throwable th) {
                LOG.warn("{}: {}", (Object)th.getClass().getName(), (Object)th.getMessage());
                return false;
            }
            if (result == null) {
                return false;
            }
            Set ids = result.allIds();
            if (ids.size() < certRequests.size()) {
                return false;
            }
            for (String id : ids) {
                CertOrError certOrError = result.getCertificateOrError(id);
                X509Certificate cert = (X509Certificate)certOrError.certificate();
                if (cert != null) continue;
                return false;
            }
            return true;
        }
    }

    private static final class CertRequestWithProfile {
        private final String certprofile;
        private final CertRequest certRequest;

        CertRequestWithProfile(String certprofile, CertRequest certRequest) {
            this.certprofile = certprofile;
            this.certRequest = certRequest;
        }
    }
}

