/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.client.shell.loadtest;

import java.io.FileInputStream;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Properties;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.bouncycastle.asn1.x509.Certificate;
import org.xipki.ca.client.shell.loadtest.CaLoadTestCommandSupport;
import org.xipki.ca.client.shell.loadtest.CaLoadTestRevoke;
import org.xipki.ca.client.shell.loadtest.DbGoodCertSerialIterator;
import org.xipki.common.util.FileBigIntegerIterator;
import org.xipki.common.util.IoUtil;
import org.xipki.console.karaf.IllegalCmdParamException;
import org.xipki.console.karaf.completer.FilePathCompleter;
import org.xipki.datasource.DataSourceFactory;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.security.SecurityFactory;

@Command(scope="xipki-cli", name="benchmark-revoke", description="CA client revoke load test")
@Service
public class CaLoadTestRevokeCmd
extends CaLoadTestCommandSupport {
    @Option(name="--issuer", required=true, description="issuer certificate file\n(required)")
    @Completion(value=FilePathCompleter.class)
    private String issuerCertFile;
    @Option(name="--duration", description="maximal duration")
    private String duration = "30s";
    @Option(name="--thread", description="number of threads")
    private Integer numThreads = 5;
    @Option(name="--ca-db", description="CA database configuration file\n(exactly one of ca-db and serial-file must be specified)")
    @Completion(value=FilePathCompleter.class)
    private String caDbConfFile;
    @Option(name="--hex", description="serial number without prefix in the serial-file is hex number")
    private Boolean hex = Boolean.FALSE;
    @Option(name="--serial-file", description="file that contains serial numbers")
    @Completion(value=FilePathCompleter.class)
    private String serialNumberFile;
    @Option(name="--max-num", description="maximal number of certificates to be revoked\n0 for unlimited")
    private Integer maxCerts = 0;
    @Option(name="-n", description="number of certificates to be revoked in one request")
    private Integer num = 1;
    @Reference
    private SecurityFactory securityFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object execute0() throws Exception {
        Object serialNumberIterator;
        if (this.numThreads < 1) {
            throw new IllegalCmdParamException("invalid number of threads " + this.numThreads);
        }
        if (!(this.serialNumberFile == null ^ this.caDbConfFile == null)) {
            throw new IllegalCmdParamException("exactly one of ca-db and serial-file must be specified");
        }
        StringBuilder description = new StringBuilder(200);
        description.append("issuer: ").append(this.issuerCertFile).append("\n");
        description.append("cadb: ").append(this.caDbConfFile).append("\n");
        description.append("serialNumberFile: ").append(this.serialNumberFile).append("\n");
        description.append("maxCerts: ").append(this.maxCerts).append("\n");
        description.append("#certs/req: ").append(this.num).append("\n");
        description.append("unit: ").append(this.num).append(" certificate");
        if (this.num > 1) {
            description.append("s");
        }
        description.append("\n");
        Certificate caCert = Certificate.getInstance((Object)IoUtil.read((String)this.issuerCertFile));
        Properties props = new Properties();
        props.load(new FileInputStream(IoUtil.expandFilepath((String)this.caDbConfFile)));
        props.setProperty("autoCommit", "false");
        props.setProperty("readOnly", "true");
        props.setProperty("maximumPoolSize", "1");
        props.setProperty("minimumIdle", "1");
        DataSourceWrapper caDataSource = null;
        if (this.caDbConfFile != null) {
            caDataSource = new DataSourceFactory().createDataSource("ds-" + this.caDbConfFile, props, this.securityFactory.getPasswordResolver());
            serialNumberIterator = new DbGoodCertSerialIterator(caCert, caDataSource);
        } else {
            serialNumberIterator = new FileBigIntegerIterator(this.serialNumberFile, this.hex.booleanValue(), false);
        }
        try {
            CaLoadTestRevoke loadTest = new CaLoadTestRevoke(this.caClient, caCert, (Iterator<BigInteger>)serialNumberIterator, this.maxCerts, this.num, description.toString());
            loadTest.setDuration(this.duration);
            loadTest.setThreads(this.numThreads);
            loadTest.test();
        }
        finally {
            if (caDataSource != null) {
                caDataSource.close();
            }
            if (serialNumberIterator instanceof FileBigIntegerIterator) {
                serialNumberIterator.close();
            }
        }
        return null;
    }
}

