/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.client.shell.loadtest;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.client.api.CaClient;
import org.xipki.ca.client.api.CaClientException;
import org.xipki.ca.client.api.CertIdOrError;
import org.xipki.ca.client.api.PkiErrorException;
import org.xipki.ca.client.api.dto.RevokeCertRequest;
import org.xipki.ca.client.api.dto.RevokeCertRequestEntry;
import org.xipki.common.LoadExecutor;
import org.xipki.common.util.CollectionUtil;
import org.xipki.common.util.ParamUtil;
import org.xipki.datasource.springframework.dao.DataAccessException;
import org.xipki.security.CrlReason;

public class CaLoadTestRevoke
extends LoadExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(CaLoadTestRevoke.class);
    private static final CrlReason[] REASONS = new CrlReason[]{CrlReason.UNSPECIFIED, CrlReason.KEY_COMPROMISE, CrlReason.AFFILIATION_CHANGED, CrlReason.SUPERSEDED, CrlReason.CESSATION_OF_OPERATION, CrlReason.CERTIFICATE_HOLD, CrlReason.PRIVILEGE_WITHDRAWN};
    private final CaClient caClient;
    private final X500Name caSubject;
    private final int num;
    private final int maxCerts;
    private final Iterator<BigInteger> serialNumberIterator;
    private AtomicInteger processedCerts = new AtomicInteger(0);

    public CaLoadTestRevoke(CaClient caClient, Certificate caCert, Iterator<BigInteger> serialNumberIterator, int maxCerts, int num, String description) throws Exception {
        super(description);
        ParamUtil.requireNonNull((String)"caCert", (Object)caCert);
        this.num = ParamUtil.requireMin((String)"num", (int)num, (int)1);
        this.caClient = (CaClient)ParamUtil.requireNonNull((String)"caClient", (Object)caClient);
        this.serialNumberIterator = (Iterator)ParamUtil.requireNonNull((String)"serialNumberIterator", serialNumberIterator);
        this.caSubject = caCert.getSubject();
        this.maxCerts = maxCerts;
    }

    protected Runnable getTestor() throws Exception {
        return new Testor();
    }

    private List<BigInteger> nextSerials() throws DataAccessException {
        int num;
        ArrayList<BigInteger> ret = new ArrayList<BigInteger>(this.num);
        for (int i = 0; i < this.num && (this.maxCerts <= 0 || (num = this.processedCerts.getAndAdd(1)) < this.maxCerts) && this.serialNumberIterator.hasNext(); ++i) {
            BigInteger serial = this.serialNumberIterator.next();
            ret.add(serial);
        }
        return ret;
    }

    class Testor
    implements Runnable {
        Testor() {
        }

        @Override
        public void run() {
            while (!CaLoadTestRevoke.this.stop() && CaLoadTestRevoke.this.getErrorAccout() < 1L) {
                List serialNumbers;
                try {
                    serialNumbers = CaLoadTestRevoke.this.nextSerials();
                }
                catch (DataAccessException ex) {
                    CaLoadTestRevoke.this.account(1, 1);
                    break;
                }
                if (CollectionUtil.isEmpty((Collection)serialNumbers)) break;
                boolean successful = this.testNext(serialNumbers);
                int numFailed = successful ? 0 : 1;
                CaLoadTestRevoke.this.account(1, numFailed);
            }
        }

        private boolean testNext(List<BigInteger> serialNumbers) {
            Map result;
            RevokeCertRequest request = new RevokeCertRequest();
            int id = 1;
            for (BigInteger serialNumber : serialNumbers) {
                CrlReason reason = REASONS[Math.abs(serialNumber.intValue()) % REASONS.length];
                CertIdOrError entry = new RevokeCertRequestEntry(Integer.toString(id++), CaLoadTestRevoke.this.caSubject, serialNumber, reason.code(), null);
                request.addRequestEntry((RevokeCertRequestEntry)entry);
            }
            try {
                result = CaLoadTestRevoke.this.caClient.revokeCerts(request, null);
            }
            catch (CaClientException | PkiErrorException ex) {
                LOG.warn("{}: {}", (Object)ex.getClass().getName(), (Object)ex.getMessage());
                return false;
            }
            catch (Throwable th) {
                LOG.warn("{}: {}", (Object)th.getClass().getName(), (Object)th.getMessage());
                return false;
            }
            if (result == null) {
                return false;
            }
            int numSuccess = 0;
            for (CertIdOrError entry : result.values()) {
                if (entry.certId() == null) continue;
                ++numSuccess;
            }
            return numSuccess == serialNumbers.size();
        }
    }
}

