/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.client.shell.loadtest;

import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.ca.client.shell.loadtest.CaLoadTestCommandSupport;
import org.xipki.ca.client.shell.loadtest.CaLoadTestEnroll;
import org.xipki.ca.client.shell.loadtest.KeyEntry;
import org.xipki.ca.client.shell.loadtest.LoadTestEntry;
import org.xipki.ca.client.shell.loadtest.completer.RandomDnCompleter;
import org.xipki.common.util.StringUtil;
import org.xipki.console.karaf.IllegalCmdParamException;
import org.xipki.console.karaf.completer.ECCurveNameCompleter;

@Command(scope="xipki-cli", name="benchmark-enroll", description="CA client enroll load test")
@Service
public class CaLoadTestEnrollCmd
extends CaLoadTestCommandSupport {
    @Option(name="--profile", aliases={"-p"}, required=true, description="certificate profile that allows duplication of public key\n(required)")
    private String certprofile;
    @Option(name="--subject", aliases={"-s"}, required=true, description="subject template\n(required)")
    private String subjectTemplate;
    @Option(name="--random-dn", description="DN name to be incremented")
    @Completion(value=RandomDnCompleter.class)
    private String randomDnStr = "O";
    @Option(name="--duration", description="duration")
    private String duration = "30s";
    @Option(name="--thread", description="number of threads")
    private Integer numThreads = 5;
    @Option(name="--key-type", description="key type to be requested")
    private String keyType = "RSA";
    @Option(name="--key-size", description="modulus length of RSA key or p length of DSA key")
    private Integer keysize = 2048;
    @Option(name="--curve", description="EC curve name or OID of EC key")
    @Completion(value=ECCurveNameCompleter.class)
    private String curveName;
    @Option(name="-n", description="number of certificates to be requested in one request")
    private Integer num = 1;
    @Option(name="--max-num", description="maximal number of requests\n0 for unlimited")
    private Integer maxRequests = 0;

    protected Object execute0() throws Exception {
        KeyEntry keyEntry;
        if (this.numThreads < 1) {
            throw new IllegalCmdParamException("invalid number of threads " + this.numThreads);
        }
        if ("EC".equalsIgnoreCase(this.keyType) && StringUtil.isBlank((String)this.curveName)) {
            throw new IllegalCmdParamException("curveName is not specified");
        }
        StringBuilder description = new StringBuilder(200);
        description.append("subjectTemplate: ").append(this.subjectTemplate).append("\n");
        description.append("profile: ").append(this.certprofile).append("\n");
        description.append("keyType: ").append(this.keyType).append("\n");
        description.append("maxRequests: ").append(this.maxRequests).append("\n");
        description.append("unit: ").append(this.num).append(" certificate");
        if (this.num > 1) {
            description.append("s");
        }
        LoadTestEntry.RandomDn randomDn = null;
        if (this.randomDnStr != null && (randomDn = LoadTestEntry.RandomDn.getInstance(this.randomDnStr)) == null) {
            throw new IllegalCmdParamException("invalid randomDN " + this.randomDnStr);
        }
        if ("EC".equalsIgnoreCase(this.keyType)) {
            keyEntry = new KeyEntry.ECKeyEntry(this.curveName);
        } else if ("RSA".equalsIgnoreCase(this.keyType)) {
            keyEntry = new KeyEntry.RSAKeyEntry(this.keysize);
        } else if ("DSA".equalsIgnoreCase(this.keyType)) {
            keyEntry = new KeyEntry.DSAKeyEntry(this.keysize);
        } else {
            throw new IllegalCmdParamException("invalid keyType " + this.keyType);
        }
        LoadTestEntry loadtestEntry = new LoadTestEntry(this.certprofile, keyEntry, this.subjectTemplate, randomDn);
        CaLoadTestEnroll loadTest = new CaLoadTestEnroll(this.caClient, loadtestEntry, this.maxRequests, this.num, description.toString());
        loadTest.setDuration(this.duration);
        loadTest.setThreads(this.numThreads);
        loadTest.test();
        return null;
    }
}

