/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.client.shell.loadtest;

import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.bouncycastle.asn1.crmf.CertRequest;
import org.bouncycastle.asn1.crmf.CertTemplate;
import org.bouncycastle.asn1.crmf.CertTemplateBuilder;
import org.bouncycastle.asn1.crmf.ProofOfPossession;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.client.api.CaClient;
import org.xipki.ca.client.api.CaClientException;
import org.xipki.ca.client.api.CertOrError;
import org.xipki.ca.client.api.EnrollCertResult;
import org.xipki.ca.client.api.PkiErrorException;
import org.xipki.ca.client.api.dto.EnrollCertRequest;
import org.xipki.ca.client.api.dto.EnrollCertRequestEntry;
import org.xipki.ca.client.shell.loadtest.LoadTestEntry;
import org.xipki.common.LoadExecutor;
import org.xipki.common.util.ParamUtil;

public class CaLoadTestEnroll
extends LoadExecutor {
    private static final ProofOfPossession RA_VERIFIED = new ProofOfPossession();
    private static final Logger LOG = LoggerFactory.getLogger(CaLoadTestEnroll.class);
    private final CaClient caClient;
    private final LoadTestEntry loadtestEntry;
    private final AtomicLong index;
    private final int num;
    private final int maxRequests;
    private AtomicInteger processedRequests = new AtomicInteger(0);

    public CaLoadTestEnroll(CaClient caClient, LoadTestEntry loadtestEntry, int maxRequests, int num, String description) {
        super(description);
        this.maxRequests = maxRequests;
        this.num = ParamUtil.requireMin((String)"num", (int)num, (int)1);
        this.loadtestEntry = (LoadTestEntry)ParamUtil.requireNonNull((String)"loadtestEntry", (Object)loadtestEntry);
        this.caClient = (CaClient)ParamUtil.requireNonNull((String)"caClient", (Object)caClient);
        this.index = new AtomicLong(CaLoadTestEnroll.getSecureIndex());
    }

    protected Runnable getTestor() throws Exception {
        return new Testor();
    }

    private Map<Integer, CertRequest> nextCertRequests() {
        int num;
        if (this.maxRequests > 0 && (num = this.processedRequests.getAndAdd(1)) >= this.maxRequests) {
            return null;
        }
        HashMap<Integer, CertRequest> certRequests = new HashMap<Integer, CertRequest>();
        for (int i = 0; i < this.num; ++i) {
            int certId = i + 1;
            CertTemplateBuilder certTempBuilder = new CertTemplateBuilder();
            long thisIndex = this.index.getAndIncrement();
            certTempBuilder.setSubject(this.loadtestEntry.getX500Name(thisIndex));
            SubjectPublicKeyInfo spki = this.loadtestEntry.getSubjectPublicKeyInfo();
            certTempBuilder.setPublicKey(spki);
            CertTemplate certTemplate = certTempBuilder.build();
            CertRequest certRequest = new CertRequest(certId, certTemplate, null);
            certRequests.put(certId, certRequest);
        }
        return certRequests;
    }

    class Testor
    implements Runnable {
        Testor() {
        }

        @Override
        public void run() {
            Map certReqs;
            while (!CaLoadTestEnroll.this.stop() && CaLoadTestEnroll.this.getErrorAccout() < 1L && (certReqs = CaLoadTestEnroll.this.nextCertRequests()) != null) {
                boolean successful = this.testNext(certReqs);
                int numFailed = successful ? 0 : 1;
                CaLoadTestEnroll.this.account(1, numFailed);
            }
        }

        private boolean testNext(Map<Integer, CertRequest> certRequests) {
            EnrollCertResult result;
            try {
                EnrollCertRequest request = new EnrollCertRequest(EnrollCertRequest.Type.CERT_REQ);
                for (Integer certId : certRequests.keySet()) {
                    String id = "id-" + certId;
                    EnrollCertRequestEntry requestEntry = new EnrollCertRequestEntry(id, CaLoadTestEnroll.this.loadtestEntry.certprofile(), certRequests.get(certId), RA_VERIFIED);
                    request.addRequestEntry(requestEntry);
                }
                result = CaLoadTestEnroll.this.caClient.requestCerts(null, request, null);
            }
            catch (CaClientException | PkiErrorException ex) {
                LOG.warn("{}: {}", (Object)ex.getClass().getName(), (Object)ex.getMessage());
                return false;
            }
            catch (Throwable th) {
                LOG.warn("{}: {}", (Object)th.getClass().getName(), (Object)th.getMessage());
                return false;
            }
            if (result == null) {
                return false;
            }
            Set ids = result.allIds();
            int numSuccess = 0;
            for (String id : ids) {
                CertOrError certOrError = result.getCertificateOrError(id);
                X509Certificate cert = (X509Certificate)certOrError.certificate();
                if (cert == null) continue;
                ++numSuccess;
            }
            return numSuccess == certRequests.size();
        }
    }
}

