/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.serveremulator;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.cmp.PKIMessage;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSAbsentContent;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.scep.exception.MessageDecodingException;
import org.xipki.scep.message.CaCaps;
import org.xipki.scep.message.NextCaMessage;
import org.xipki.scep.serveremulator.AuditEvent;
import org.xipki.scep.serveremulator.CaException;
import org.xipki.scep.serveremulator.ScepResponder;
import org.xipki.scep.transaction.CaCapability;
import org.xipki.scep.transaction.Operation;
import org.xipki.scep.util.ScepUtil;

public class ScepServlet
extends HttpServlet {
    private static final long serialVersionUID = 7442535012222114067L;
    private static final Logger LOG = LoggerFactory.getLogger(ScepServlet.class);
    private static final String CT_RESPONSE = "application/x-pki-message";
    private ScepResponder responder;

    public ScepServlet(ScepResponder responder) {
        this.responder = (ScepResponder)ScepUtil.requireNonNull((String)"responder", (Object)responder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block48: {
            boolean post;
            String method = req.getMethod();
            if ("GET".equals(method)) {
                post = false;
            } else if ("POST".equals(method)) {
                post = true;
            } else {
                resp.sendError(405);
                return;
            }
            AuditEvent event = new AuditEvent();
            event.setName("PERF");
            event.putEventData("servletPath", req.getServletPath());
            AuditEvent.AuditLevel auditLevel = AuditEvent.AuditLevel.INFO;
            String auditMessage = null;
            try {
                CaCaps caCaps = this.responder.caCaps();
                if (post && !caCaps.containsCapability(CaCapability.POSTPKIOperation)) {
                    String message = "HTTP POST is not supported";
                    LOG.error("HTTP POST is not supported");
                    auditMessage = "HTTP POST is not supported";
                    auditLevel = AuditEvent.AuditLevel.ERROR;
                    resp.sendError(400);
                    return;
                }
                String operation = req.getParameter("operation");
                event.putEventData("operation", operation);
                if ("PKIOperation".equalsIgnoreCase(operation)) {
                    ContentInfo ci;
                    CMSSignedData reqMessage;
                    try {
                        byte[] content;
                        if (post) {
                            content = ScepUtil.read((InputStream)req.getInputStream());
                        } else {
                            String b64 = req.getParameter("message");
                            content = Base64.decode((String)b64);
                        }
                        reqMessage = new CMSSignedData(content);
                    }
                    catch (Exception ex) {
                        String message = "invalid request";
                        LOG.error("invalid request", (Object)LOG);
                        auditMessage = "invalid request";
                        auditLevel = AuditEvent.AuditLevel.ERROR;
                        resp.sendError(400);
                        if (event.level() != AuditEvent.AuditLevel.ERROR) {
                            event.setLevel(auditLevel);
                        }
                        if (auditMessage != null) {
                            event.putEventData("error", auditMessage);
                        }
                        event.log(LOG);
                        return;
                    }
                    try {
                        ci = this.responder.servicePkiOperation(reqMessage, event);
                    }
                    catch (MessageDecodingException ex) {
                        String message = "could not decrypt and/or verify the request";
                        LOG.error("could not decrypt and/or verify the request", (Throwable)ex);
                        auditMessage = "could not decrypt and/or verify the request";
                        auditLevel = AuditEvent.AuditLevel.ERROR;
                        resp.sendError(400);
                        if (event.level() != AuditEvent.AuditLevel.ERROR) {
                            event.setLevel(auditLevel);
                        }
                        if (auditMessage != null) {
                            event.putEventData("error", auditMessage);
                        }
                        event.log(LOG);
                        return;
                    }
                    catch (CaException ex) {
                        String message = "system internal error";
                        LOG.error("system internal error", (Throwable)ex);
                        auditMessage = "system internal error";
                        auditLevel = AuditEvent.AuditLevel.ERROR;
                        resp.sendError(500);
                        if (event.level() != AuditEvent.AuditLevel.ERROR) {
                            event.setLevel(auditLevel);
                        }
                        if (auditMessage != null) {
                            event.putEventData("error", auditMessage);
                        }
                        event.log(LOG);
                        return;
                    }
                    byte[] respBytes = ci.getEncoded();
                    this.sendToResponse(resp, CT_RESPONSE, respBytes);
                    break block48;
                }
                if (Operation.GetCACaps.code().equalsIgnoreCase(operation)) {
                    byte[] caCapsBytes = this.responder.caCaps().bytes();
                    this.sendToResponse(resp, "text/plain", caCapsBytes);
                    break block48;
                }
                if (Operation.GetCACert.code().equalsIgnoreCase(operation)) {
                    byte[] respBytes;
                    String ct;
                    if (this.responder.raEmulator() == null) {
                        ct = "application/x-x509-ca-cert";
                        respBytes = this.responder.caEmulator().caCertBytes();
                    } else {
                        ct = "application/x-x509-ca-ra-cert";
                        CMSSignedDataGenerator cmsSignedDataGen = new CMSSignedDataGenerator();
                        try {
                            cmsSignedDataGen.addCertificate(new X509CertificateHolder(this.responder.caEmulator().caCert()));
                            ct = "application/x-x509-ca-ra-cert";
                            cmsSignedDataGen.addCertificate(new X509CertificateHolder(this.responder.raEmulator().raCert()));
                            CMSSignedData degenerateSignedData = cmsSignedDataGen.generate((CMSTypedData)new CMSAbsentContent());
                            respBytes = degenerateSignedData.getEncoded();
                        }
                        catch (CMSException ex) {
                            String message = "system internal error";
                            LOG.error("system internal error", (Throwable)ex);
                            auditMessage = "system internal error";
                            auditLevel = AuditEvent.AuditLevel.ERROR;
                            resp.sendError(500);
                            if (event.level() != AuditEvent.AuditLevel.ERROR) {
                                event.setLevel(auditLevel);
                            }
                            if (auditMessage != null) {
                                event.putEventData("error", auditMessage);
                            }
                            event.log(LOG);
                            return;
                        }
                    }
                    this.sendToResponse(resp, ct, respBytes);
                    break block48;
                }
                if (Operation.GetNextCACert.code().equalsIgnoreCase(operation)) {
                    if (this.responder.nextCaAndRa() == null) {
                        auditMessage = "SCEP operation '" + operation + "' is not permitted";
                        auditLevel = AuditEvent.AuditLevel.ERROR;
                        resp.sendError(403);
                        return;
                    }
                    try {
                        NextCaMessage nextCaMsg = new NextCaMessage();
                        nextCaMsg.setCaCert(ScepUtil.toX509Cert((Certificate)this.responder.nextCaAndRa().caCert()));
                        if (this.responder.nextCaAndRa().raCert() != null) {
                            X509Certificate raCert = ScepUtil.toX509Cert((Certificate)this.responder.nextCaAndRa().raCert());
                            nextCaMsg.setRaCerts(Arrays.asList(raCert));
                        }
                        ContentInfo signedData = this.responder.encode(nextCaMsg);
                        byte[] respBytes = signedData.getEncoded();
                        this.sendToResponse(resp, "application/x-x509-next-ca-cert", respBytes);
                    }
                    catch (Exception ex) {
                        String message = "system internal error";
                        LOG.error("system internal error", (Object)LOG);
                        auditMessage = "system internal error";
                        auditLevel = AuditEvent.AuditLevel.ERROR;
                        resp.sendError(500);
                    }
                } else {
                    auditMessage = "unknown SCEP operation '" + operation + "'";
                    auditLevel = AuditEvent.AuditLevel.ERROR;
                    resp.sendError(400);
                }
                break block48;
                {
                    catch (EOFException ex) {
                        LOG.warn("connection reset by peer", (Throwable)ex);
                        resp.sendError(500);
                        break block48;
                    }
                    catch (Throwable th) {
                        LOG.error("Throwable thrown, this should not happen!", th);
                        auditLevel = AuditEvent.AuditLevel.ERROR;
                        auditMessage = "internal error";
                        resp.sendError(500);
                        break block48;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (event.level() != AuditEvent.AuditLevel.ERROR) {
                    event.setLevel(auditLevel);
                }
                if (auditMessage != null) {
                    event.putEventData("error", auditMessage);
                }
                event.log(LOG);
            }
        }
    }

    private void sendToResponse(HttpServletResponse resp, String contentType, byte[] body) throws IOException {
        resp.setContentType(contentType);
        resp.setContentLength(body.length);
        resp.getOutputStream().write(body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PKIMessage generatePkiMessage(InputStream is) throws IOException {
        ScepUtil.requireNonNull((String)"is", (Object)is);
        ASN1InputStream asn1Stream = new ASN1InputStream(is);
        try {
            PKIMessage pKIMessage = PKIMessage.getInstance((Object)asn1Stream.readObject());
            return pKIMessage;
        }
        finally {
            try {
                asn1Stream.close();
            }
            catch (Exception ex) {
                LOG.error("could not close stream: {}", (Object)ex.getMessage());
            }
        }
    }
}

